/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileWriterWithEncoding
extends Writer {
    private final Writer out;

    public FileWriterWithEncoding(String filename, String encoding2) throws IOException {
        this(new File(filename), encoding2, false);
    }

    public FileWriterWithEncoding(String filename, String encoding2, boolean append) throws IOException {
        this(new File(filename), encoding2, append);
    }

    public FileWriterWithEncoding(String filename, Charset encoding2) throws IOException {
        this(new File(filename), encoding2, false);
    }

    public FileWriterWithEncoding(String filename, Charset encoding2, boolean append) throws IOException {
        this(new File(filename), encoding2, append);
    }

    public FileWriterWithEncoding(String filename, CharsetEncoder encoding2) throws IOException {
        this(new File(filename), encoding2, false);
    }

    public FileWriterWithEncoding(String filename, CharsetEncoder encoding2, boolean append) throws IOException {
        this(new File(filename), encoding2, append);
    }

    public FileWriterWithEncoding(File file2, String encoding2) throws IOException {
        this(file2, encoding2, false);
    }

    public FileWriterWithEncoding(File file2, String encoding2, boolean append) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, encoding2, append);
    }

    public FileWriterWithEncoding(File file2, Charset encoding2) throws IOException {
        this(file2, encoding2, false);
    }

    public FileWriterWithEncoding(File file2, Charset encoding2, boolean append) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, encoding2, append);
    }

    public FileWriterWithEncoding(File file2, CharsetEncoder encoding2) throws IOException {
        this(file2, encoding2, false);
    }

    public FileWriterWithEncoding(File file2, CharsetEncoder encoding2, boolean append) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file2, encoding2, append);
    }

    private static Writer initWriter(File file2, Object encoding2, boolean append) throws IOException {
        if (file2 == null) {
            throw new NullPointerException("File is missing");
        }
        if (encoding2 == null) {
            throw new NullPointerException("Encoding is missing");
        }
        boolean fileExistedAlready = file2.exists();
        FileOutputStream stream = null;
        OutputStreamWriter writer2 = null;
        try {
            stream = new FileOutputStream(file2, append);
            writer2 = encoding2 instanceof Charset ? new OutputStreamWriter((OutputStream)stream, (Charset)encoding2) : (encoding2 instanceof CharsetEncoder ? new OutputStreamWriter((OutputStream)stream, (CharsetEncoder)encoding2) : new OutputStreamWriter((OutputStream)stream, (String)encoding2));
        }
        catch (IOException ex) {
            IOUtils.closeQuietly(writer2);
            IOUtils.closeQuietly(stream);
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file2);
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            IOUtils.closeQuietly(writer2);
            IOUtils.closeQuietly(stream);
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file2);
            }
            throw ex;
        }
        return writer2;
    }

    @Override
    public void write(int idx) throws IOException {
        this.out.write(idx);
    }

    @Override
    public void write(char[] chr) throws IOException {
        this.out.write(chr);
    }

    @Override
    public void write(char[] chr, int st, int end) throws IOException {
        this.out.write(chr, st, end);
    }

    @Override
    public void write(String str2) throws IOException {
        this.out.write(str2);
    }

    @Override
    public void write(String str2, int st, int end) throws IOException {
        this.out.write(str2, st, end);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

