'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
const NEW = Symbol('new');

const NO_REPLY_GITHUB_EMAIL = exports.NO_REPLY_GITHUB_EMAIL = 'noreply@github.com';

class Author {
  constructor(email, fullName, login = null, isNew = null) {
    this.email = email;
    this.fullName = fullName;
    this.login = login;
    this.new = isNew === NEW;
  }

  static createNew(email, fullName) {
    return new this(email, fullName, null, NEW);
  }

  getEmail() {
    return this.email;
  }

  getFullName() {
    return this.fullName;
  }

  getLogin() {
    return this.login;
  }

  isNoReply() {
    return this.email === NO_REPLY_GITHUB_EMAIL;
  }

  hasLogin() {
    return this.login !== null;
  }

  isNew() {
    return this.new;
  }

  isPresent() {
    return true;
  }

  matches(other) {
    return this.getEmail() === other.getEmail();
  }

  toString() {
    let s = `${this.fullName} <${this.email}>`;
    if (this.hasLogin()) {
      s += ` @${this.login}`;
    }
    return s;
  }

  static compare(a, b) {
    if (a.getFullName() < b.getFullName()) {
      return -1;
    }
    if (a.getFullName() > b.getFullName()) {
      return 1;
    }
    return 0;
  }
}

exports.default = Author;
const nullAuthor = exports.nullAuthor = {
  getEmail() {
    return '';
  },

  getFullName() {
    return '';
  },

  getLogin() {
    return null;
  },

  isNoReply() {
    return false;
  },

  hasLogin() {
    return false;
  },

  isNew() {
    return false;
  },

  isPresent() {
    return false;
  },

  matches(other) {
    return other === this;
  },

  toString() {
    return 'null author';
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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