'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DecorableContext = exports.MarkerContext = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _atomTextEditor = require('./atom-text-editor');

var _markerLayer = require('./marker-layer');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const MarkablePropType = _propTypes2.default.shape({
  markBufferRange: _propTypes2.default.func.isRequired
});

const markerProps = {
  reversed: _propTypes2.default.bool,
  invalidate: _propTypes2.default.oneOf(['never', 'surround', 'overlap', 'inside', 'touch'])
};

const MarkerContext = exports.MarkerContext = _react2.default.createContext();

const DecorableContext = exports.DecorableContext = _react2.default.createContext();

class BareMarker extends _react2.default.Component {

  constructor(props) {
    super(props);

    (0, _helpers.autobind)(this, 'createMarker', 'didChange');

    this.markerSubs = new _eventKit.CompositeDisposable();
    this.subs = new _eventKit.CompositeDisposable();

    this.markerHolder = new _refHolder2.default();
    this.markerHolder.observe(marker => {
      this.props.handleMarker(marker);
    });

    this.decorable = {
      holder: this.markerHolder,
      decorateMethod: 'decorateMarker'
    };
  }

  componentDidMount() {
    this.observeMarkable();
  }

  render() {
    return _react2.default.createElement(
      MarkerContext.Provider,
      { value: this.markerHolder },
      _react2.default.createElement(
        DecorableContext.Provider,
        { value: this.decorable },
        this.props.children
      )
    );
  }

  componentDidUpdate(prevProps) {
    if (prevProps.markableHolder !== this.props.markableHolder) {
      this.observeMarkable();
    }

    if (Object.keys(markerProps).some(key => prevProps[key] !== this.props[key])) {
      this.markerHolder.map(marker => marker.setProperties((0, _helpers.extractProps)(this.props, markerProps)));
    }

    this.updateMarkerPosition();
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  observeMarkable() {
    this.subs.dispose();
    this.subs = new _eventKit.CompositeDisposable();
    this.subs.add(this.props.markableHolder.observe(this.createMarker));
  }

  createMarker() {
    this.markerSubs.dispose();
    this.markerSubs = new _eventKit.CompositeDisposable();
    this.subs.add(this.markerSubs);

    const options = (0, _helpers.extractProps)(this.props, markerProps);

    this.props.markableHolder.map(markable => {
      let marker;

      if (this.props.id !== undefined) {
        marker = markable.getMarker(this.props.id);
        if (!marker) {
          throw new Error(`Invalid marker ID: ${this.props.id}`);
        }
        marker.setProperties(options);
      } else {
        marker = markable.markBufferRange(this.props.bufferRange, options);
        this.markerSubs.add(new _eventKit.Disposable(() => marker.destroy()));
      }

      this.markerSubs.add(marker.onDidChange(this.didChange));
      this.markerHolder.setter(marker);
      this.props.handleID(marker.id);
      return null;
    });
  }

  updateMarkerPosition() {
    this.markerHolder.map(marker => marker.setBufferRange(this.props.bufferRange));
  }

  didChange(event) {
    const reversed = this.markerHolder.map(marker => marker.isReversed()).getOr(false);

    const oldBufferStartPosition = reversed ? event.oldHeadBufferPosition : event.oldTailBufferPosition;
    const oldBufferEndPosition = reversed ? event.oldTailBufferPosition : event.oldHeadBufferPosition;

    const newBufferStartPosition = reversed ? event.newHeadBufferPosition : event.newTailBufferPosition;
    const newBufferEndPosition = reversed ? event.newTailBufferPosition : event.newHeadBufferPosition;

    this.props.onDidChange(_extends({
      oldRange: new Range(oldBufferStartPosition, oldBufferEndPosition),
      newRange: new Range(newBufferStartPosition, newBufferEndPosition)
    }, event));
  }
}

BareMarker.propTypes = _extends({}, markerProps, {
  id: _propTypes2.default.string,
  bufferRange: _propTypes3.RangePropType,
  markableHolder: _propTypes3.RefHolderPropType,
  children: _propTypes2.default.node,
  onDidChange: _propTypes2.default.func,
  handleID: _propTypes2.default.func,
  handleMarker: _propTypes2.default.func
});
BareMarker.defaultProps = {
  onDidChange: () => {},
  handleID: () => {},
  handleMarker: () => {}
};
class Marker extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.state = {
      markableHolder: _refHolder2.default.on(props.layer || props.editor)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const markable = props.layer || props.editor;

    if (state.markableHolder.map(m => m === markable).getOr(markable === undefined)) {
      return {};
    }

    return {
      markableHolder: _refHolder2.default.on(markable)
    };
  }

  render() {
    if (!this.state.markableHolder.isEmpty()) {
      return _react2.default.createElement(BareMarker, _extends({}, this.props, { markableHolder: this.state.markableHolder }));
    }

    return _react2.default.createElement(
      _markerLayer.MarkerLayerContext.Consumer,
      null,
      layerHolder => {
        if (layerHolder) {
          return _react2.default.createElement(BareMarker, _extends({}, this.props, { markableHolder: layerHolder }));
        } else {
          return _react2.default.createElement(
            _atomTextEditor.TextEditorContext.Consumer,
            null,
            editorHolder => _react2.default.createElement(BareMarker, _extends({}, this.props, { markableHolder: editorHolder }))
          );
        }
      }
    );
  }
}
exports.default = Marker;
Marker.propTypes = {
  editor: MarkablePropType,
  layer: MarkablePropType
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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