/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.xslt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.converter.dom.DOMDocument;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.xslt.GenericOfficeDocument;
import org.openoffice.xmerge.converter.xml.xslt.PluginFactoryImpl;
import org.openoffice.xmerge.util.registry.ConverterInfo;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DocumentSerializerImpl
implements DocumentSerializer,
OfficeConstants,
URIResolver {
    private final GenericOfficeDocument sxwDoc;
    private final PluginFactoryImpl pluginFactory;

    public DocumentSerializerImpl(PluginFactoryImpl pf, Document doc) {
        this.pluginFactory = pf;
        this.sxwDoc = (GenericOfficeDocument)doc;
    }

    public ConvertData serialize() throws ConvertException, IOException {
        String docName = this.sxwDoc.getName();
        org.w3c.dom.Document domDoc = this.sxwDoc.getContentDOM();
        org.w3c.dom.Document metaDoc = this.sxwDoc.getMetaDOM();
        org.w3c.dom.Document styleDoc = this.sxwDoc.getStyleDOM();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ConvertData cd = new ConvertData();
        Element offnode = domDoc.getDocumentElement();
        if (!offnode.getNodeName().equals("office:document")) {
            try {
                Node tmpNode;
                NodeList nodeList;
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                DOMImplementation domImpl = builder.getDOMImplementation();
                DocumentType docType = domImpl.createDocumentType("office:document", "-//OpenOffice.org//DTD OfficeDocument 1.0//EN", null);
                org.w3c.dom.Document newDoc = domImpl.createDocument("http://openoffice.org/2000/office", "office:document", docType);
                Element rootElement = newDoc.getDocumentElement();
                rootElement.setAttribute("xmlns:office", "http://openoffice.org/2000/office");
                rootElement.setAttribute("xmlns:style", "http://openoffice.org/2000/style");
                rootElement.setAttribute("xmlns:text", "http://openoffice.org/2000/text");
                rootElement.setAttribute("xmlns:table", "http://openoffice.org/2000/table");
                rootElement.setAttribute("xmlns:draw", "http://openoffice.org/2000/drawing");
                rootElement.setAttribute("xmlns:fo", "http://www.w3.org/1999/XSL/Format");
                rootElement.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
                rootElement.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
                rootElement.setAttribute("xmlns:meta", "http://openoffice.org/2000/meta");
                rootElement.setAttribute("xmlns:number", "http://openoffice.org/2000/datastyle");
                rootElement.setAttribute("xmlns:svg", "http://www.w3.org/2000/svg");
                rootElement.setAttribute("xmlns:chart", "http://openoffice.org/2000/chart");
                rootElement.setAttribute("xmlns:dr3d", "http://openoffice.org/2000/dr3d");
                rootElement.setAttribute("xmlns:math", "http://www.w3.org/1998/Math/MathML");
                rootElement.setAttribute("xmlns:form", "http://openoffice.org/2000/form");
                rootElement.setAttribute("xmlns:script", "http://openoffice.org/2000/script");
                rootElement.setAttribute("xmlns:config", "http://openoffice.org/2001/config");
                rootElement.setAttribute("office:class", "text");
                rootElement.setAttribute("office:version", "1.0");
                Element rootNode = rootElement;
                if (metaDoc != null && (nodeList = metaDoc.getElementsByTagName("office:meta")).getLength() > 0) {
                    tmpNode = newDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                if (styleDoc != null && (nodeList = styleDoc.getElementsByTagName("office:styles")).getLength() > 0) {
                    tmpNode = newDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                if ((nodeList = domDoc.getElementsByTagName("office:automatic-styles")).getLength() > 0) {
                    tmpNode = newDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                if ((nodeList = domDoc.getElementsByTagName("office:body")).getLength() > 0) {
                    tmpNode = newDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                domDoc = newDoc;
            }
            catch (Exception e) {
                System.out.println("\nAn Exception occurred with Xslt Serializer" + e);
            }
        }
        try {
            baos = this.transform(domDoc);
        }
        catch (Exception e) {
            System.out.println("\n Error with Xslt\n");
        }
        DOMDocument resultDomDoc = (DOMDocument)this.pluginFactory.createDeviceDocument(docName, new ByteArrayInputStream(baos.toByteArray()));
        cd.addDocument(resultDomDoc);
        return cd;
    }

    public Source resolve(String href, String base) throws TransformerException {
        if (href != null) {
            if (href.equals("javax.xml.transform.dom.DOMSource") || href.length() == 0) {
                return null;
            }
            try {
                ConverterInfo ci = this.pluginFactory.getConverterInfo();
                String newhRef = "jar:" + ci.getJarName() + "!/" + href;
                StreamSource sheetFile = new StreamSource(newhRef);
                return sheetFile;
            }
            catch (Exception e) {
                System.out.println("\nException in Xslt Resolver " + e);
                return null;
            }
        }
        return null;
    }

    private ByteArrayOutputStream transform(org.w3c.dom.Document domDoc) {
        ConverterInfo ci = this.pluginFactory.getConverterInfo();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
            String teststr = ci.getXsltSerial();
            teststr = teststr.substring(0, 6);
            org.w3c.dom.Document xslDoc = null;
            if (teststr.equals("http:/") || teststr.equals("file:/") || teststr.equals("jar://")) {
                System.out.println(ci.getXsltSerial());
                xslDoc = dBuilder.parse(ci.getXsltSerial());
            } else {
                xslDoc = dBuilder.parse("jar:" + ci.getJarName() + "!/" + ci.getXsltSerial());
            }
            DOMSource xslDomSource = new DOMSource(xslDoc);
            DOMSource xmlDomSource = new DOMSource(domDoc);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setURIResolver(this);
            Transformer transformer = tFactory.newTransformer(xslDomSource);
            transformer.transform(xmlDomSource, new StreamResult(baos));
        }
        catch (Exception e) {
            System.out.println("An error occurred in the transformation : " + e);
        }
        return baos;
    }
}

