/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.image;

import com.sun.prism.GraphicsResource;
import com.sun.prism.Image;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.image.CompoundImage;

public class CompoundTexture
extends CompoundImage
implements GraphicsResource {
    protected Texture[] texTiles;

    public CompoundTexture(Image image, int maxSize) {
        super(image, maxSize);
        this.texTiles = new Texture[this.tiles.length];
    }

    @Override
    public Texture getTile(int x, int y, ResourceFactory factory) {
        int idx = x + y * this.uSections;
        Texture tex = this.texTiles[idx];
        if (tex != null) {
            tex.lock();
            if (tex.isSurfaceLost()) {
                tex = null;
                this.texTiles[idx] = null;
            }
        }
        if (tex == null) {
            this.texTiles[idx] = tex = factory.createTexture(this.tiles[idx], Texture.Usage.STATIC, Texture.WrapMode.CLAMP_TO_EDGE);
        }
        return tex;
    }

    @Override
    public void dispose() {
        for (int i = 0; i != this.texTiles.length; ++i) {
            if (this.texTiles[i] == null) continue;
            this.texTiles[i].dispose();
            this.texTiles[i] = null;
        }
    }
}

