/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.effects.AudioEqualizer;
import com.sun.media.jfxmedia.effects.EqualizerBand;

final class NativeAudioEqualizer
implements AudioEqualizer {
    private final long nativeRef;

    NativeAudioEqualizer(long nativeRef) {
        if (nativeRef == 0L) {
            throw new IllegalArgumentException("Invalid native media reference");
        }
        this.nativeRef = nativeRef;
    }

    @Override
    public boolean getEnabled() {
        return this.nativeGetEnabled(this.nativeRef);
    }

    @Override
    public void setEnabled(boolean enable) {
        this.nativeSetEnabled(this.nativeRef, enable);
    }

    @Override
    public EqualizerBand addBand(double centerFrequency, double bandwidth, double gain) {
        return this.nativeGetNumBands(this.nativeRef) >= 64 && gain >= -24.0 && gain <= 12.0 ? null : this.nativeAddBand(this.nativeRef, centerFrequency, bandwidth, gain);
    }

    @Override
    public boolean removeBand(double centerFrequency) {
        return centerFrequency > 0.0 ? this.nativeRemoveBand(this.nativeRef, centerFrequency) : false;
    }

    private native boolean nativeGetEnabled(long var1);

    private native void nativeSetEnabled(long var1, boolean var3);

    private native int nativeGetNumBands(long var1);

    private native EqualizerBand nativeAddBand(long var1, double var3, double var5, double var7);

    private native boolean nativeRemoveBand(long var1, double var3);
}

