/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util.registry;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import org.openoffice.xmerge.DocumentDeserializerFactory;
import org.openoffice.xmerge.DocumentMergerFactory;
import org.openoffice.xmerge.DocumentSerializerFactory;
import org.openoffice.xmerge.PluginFactory;
import org.openoffice.xmerge.util.registry.RegistryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterInfo {
    private static final String[] validOfficeTypes = new String[]{"staroffice/sxw", "staroffice/sxc"};
    private final String piJarName;
    private final String piOfficeMime;
    private final ArrayList<String> piDeviceMime;
    private final String piDisplayName;
    private final String piDescription;
    private final String piVersion;
    private final String piVendor;
    private final String piClassImpl;
    private String piXsltSerial;
    private String piXsltDeserial;
    private boolean piCanSerialize = false;
    private boolean piCanDeserialize = false;
    private boolean piCanMerge = false;
    private final ClassLoader piClassLoader;
    private PluginFactory piPluginFactory;

    public ConverterInfo(String jarName, String officeMime, ArrayList<String> deviceMime, String displayName, String description, String version, String vendor, String impl, String xsltSerial, String xsltDeserial) throws RegistryException {
        if (!ConverterInfo.isValidOfficeType(officeMime.trim())) {
            RegistryException re = new RegistryException("Invalid office type");
            throw re;
        }
        this.piJarName = jarName.trim();
        this.piOfficeMime = officeMime.trim();
        this.piDeviceMime = deviceMime;
        this.piDisplayName = displayName.trim();
        this.piDescription = description.trim();
        this.piVersion = version.trim();
        this.piVendor = vendor.trim();
        this.piXsltSerial = xsltSerial.trim();
        this.piXsltDeserial = xsltDeserial.trim();
        this.piClassImpl = impl.trim();
        this.piClassLoader = this.getClass().getClassLoader();
        try {
            URL jarURL = new URL(jarName);
            final URL[] urls = new URL[]{jarURL};
            URLClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

                @Override
                public URLClassLoader run() {
                    return new URLClassLoader(urls, ConverterInfo.this.piClassLoader);
                }
            });
            Class<?> clas = loader.loadClass(this.piClassImpl);
            Class[] argumentTypes = new Class[]{ConverterInfo.class};
            Constructor<?> construct = clas.getConstructor(argumentTypes);
            Object[] arguments = new Object[]{this};
            this.piPluginFactory = (PluginFactory)construct.newInstance(arguments);
            Class<?>[] cl = this.piPluginFactory.getClass().getInterfaces();
            for (int i = 0; i < cl.length; ++i) {
                if (cl[i].getName().equals("org.openoffice.xmerge.DocumentSerializerFactory")) {
                    this.piCanSerialize = true;
                }
                if (cl[i].getName().equals("org.openoffice.xmerge.DocumentDeserializerFactory")) {
                    this.piCanDeserialize = true;
                }
                if (!cl[i].getName().equals("org.openoffice.xmerge.DocumentMergerFactory")) continue;
                this.piCanMerge = true;
            }
        }
        catch (Exception e) {
            throw new RegistryException("Class implementation of the plug-in cannot be loaded.", e);
        }
    }

    public ConverterInfo(String jarName, String officeMime, ArrayList<String> deviceMime, String displayName, String description, String version, String vendor, String impl) throws RegistryException {
        if (officeMime == null || displayName == null || description == null || version == null || vendor == null || impl == null) {
            throw new IllegalArgumentException("arguments unexpected null");
        }
        if (!ConverterInfo.isValidOfficeType(officeMime.trim())) {
            RegistryException re = new RegistryException("Invalid office type");
            throw re;
        }
        this.piJarName = jarName.trim();
        this.piOfficeMime = officeMime.trim();
        this.piDeviceMime = deviceMime;
        this.piDisplayName = displayName.trim();
        this.piDescription = description.trim();
        this.piVersion = version.trim();
        this.piVendor = vendor.trim();
        this.piClassImpl = impl.trim();
        this.piClassLoader = this.getClass().getClassLoader();
        try {
            URL jarURL = new URL(jarName);
            final URL[] urls = new URL[]{jarURL};
            URLClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

                @Override
                public URLClassLoader run() {
                    return new URLClassLoader(urls, ConverterInfo.this.piClassLoader);
                }
            });
            Class<?> clas = loader.loadClass(this.piClassImpl);
            Class[] argumentTypes = new Class[]{ConverterInfo.class};
            Constructor<?> construct = clas.getConstructor(argumentTypes);
            Object[] arguments = new Object[]{this};
            this.piPluginFactory = (PluginFactory)construct.newInstance(arguments);
            Class<?>[] cl = this.piPluginFactory.getClass().getInterfaces();
            for (int i = 0; i < cl.length; ++i) {
                if (cl[i].getName().equals("org.openoffice.xmerge.DocumentSerializerFactory")) {
                    this.piCanSerialize = true;
                }
                if (cl[i].getName().equals("org.openoffice.xmerge.DocumentDeserializerFactory")) {
                    this.piCanDeserialize = true;
                }
                if (!cl[i].getName().equals("org.openoffice.xmerge.DocumentMergerFactory")) continue;
                this.piCanMerge = true;
            }
        }
        catch (Exception e) {
            throw new RegistryException("Class implementation of the plug-in cannot be loaded.", e);
        }
    }

    public DocumentSerializerFactory getDocSerializerFactory() {
        return (DocumentSerializerFactory)((Object)this.piPluginFactory);
    }

    public DocumentDeserializerFactory getDocDeserializerFactory() {
        return (DocumentDeserializerFactory)((Object)this.piPluginFactory);
    }

    public DocumentMergerFactory getDocMergerFactory() {
        return (DocumentMergerFactory)((Object)this.piPluginFactory);
    }

    public String getJarName() {
        return this.piJarName;
    }

    public String getOfficeMime() {
        return this.piOfficeMime;
    }

    public Iterator<String> getDeviceMime() {
        return this.piDeviceMime.iterator();
    }

    public String getDisplayName() {
        return this.piDisplayName;
    }

    public String getDescription() {
        return this.piDescription;
    }

    public String getVersion() {
        return this.piVersion;
    }

    public String getVendor() {
        return this.piVendor;
    }

    public String getClassImpl() {
        return this.piClassImpl;
    }

    public PluginFactory getPluginFactory() {
        return this.piPluginFactory;
    }

    public boolean canSerialize() {
        return this.piCanSerialize;
    }

    public boolean canDeserialize() {
        return this.piCanDeserialize;
    }

    public boolean canMerge() {
        return this.piCanMerge;
    }

    public static boolean isValidOfficeType(String officeMime) {
        boolean rc = false;
        for (String validOfficeType : validOfficeTypes) {
            if (!officeMime.equals(validOfficeType)) continue;
            rc = true;
        }
        return rc;
    }

    public String getXsltSerial() {
        return this.piXsltSerial;
    }

    public String getXsltDeserial() {
        return this.piXsltDeserial;
    }
}

