/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.Bytecode;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.ConstantPoolCache;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.ConstantTag;

public class BytecodeLoadConstant
extends Bytecode {
    BytecodeLoadConstant(Method method, int bci) {
        super(method, bci);
    }

    public boolean hasCacheIndex() {
        return this.code() >= 203;
    }

    int rawIndex() {
        if (this.javaCode() == 18) {
            return this.getIndexU1();
        }
        return this.getIndexU2(this.code(), false);
    }

    public int poolIndex() {
        int i = this.rawIndex();
        if (this.hasCacheIndex()) {
            ConstantPoolCache cpCache = this.method().getConstants().getCache();
            return cpCache.getEntryAt(i).getConstantPoolIndex();
        }
        return i;
    }

    public int cacheIndex() {
        if (this.hasCacheIndex()) {
            return this.rawIndex();
        }
        return -1;
    }

    public BasicType resultType() {
        int index = this.poolIndex();
        ConstantTag tag = this.method().getConstants().getTagAt(index);
        return tag.basicType();
    }

    private Oop getCachedConstant() {
        int i = this.cacheIndex();
        if (i >= 0) {
            ConstantPoolCache cpCache = this.method().getConstants().getCache();
            return cpCache.getEntryAt(i).getF1();
        }
        return null;
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check load constant");
        }
    }

    public boolean isValid() {
        boolean codeOk;
        int jcode = this.javaCode();
        boolean bl = codeOk = jcode == 18 || jcode == 19 || jcode == 20;
        if (!codeOk) {
            return false;
        }
        ConstantTag ctag = this.method().getConstants().getTagAt(this.poolIndex());
        if (jcode == 20) {
            return ctag.isDouble() || ctag.isLong();
        }
        return ctag.isUnresolvedString() || ctag.isString() || ctag.isUnresolvedKlass() || ctag.isKlass() || ctag.isMethodHandle() || ctag.isMethodType() || ctag.isInt() || ctag.isFloat();
    }

    public boolean isKlassConstant() {
        int jcode = this.javaCode();
        if (jcode == 20) {
            return false;
        }
        ConstantTag ctag = this.method().getConstants().getTagAt(this.poolIndex());
        return ctag.isKlass() || ctag.isUnresolvedKlass();
    }

    public Object getKlass() {
        int cpIndex;
        ConstantPool cpool;
        ConstantPool.CPSlot oop;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isKlassConstant(), "not a klass literal");
        }
        if ((oop = (cpool = this.method().getConstants()).getSlotAt(cpIndex = this.poolIndex())).isOop()) {
            return (Klass)oop.getOop();
        }
        if (oop.isMetaData()) {
            return oop.getSymbol();
        }
        throw new RuntimeException("should not reach here");
    }

    public static BytecodeLoadConstant at(Method method, int bci) {
        BytecodeLoadConstant b = new BytecodeLoadConstant(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodeLoadConstant atCheck(Method method, int bci) {
        BytecodeLoadConstant b = new BytecodeLoadConstant(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeLoadConstant at(BytecodeStream bcs) {
        return new BytecodeLoadConstant(bcs.method(), bcs.bci());
    }

    public String getConstantValue() {
        int cpIndex;
        ConstantPool cpool = this.method().getConstants();
        ConstantTag ctag = cpool.getTagAt(cpIndex = this.poolIndex());
        if (ctag.isInt()) {
            return "<int " + Integer.toString(cpool.getIntAt(cpIndex)) + ">";
        }
        if (ctag.isLong()) {
            return "<long " + Long.toString(cpool.getLongAt(cpIndex)) + "L>";
        }
        if (ctag.isFloat()) {
            return "<float " + Float.toString(cpool.getFloatAt(cpIndex)) + "F>";
        }
        if (ctag.isDouble()) {
            return "<double " + Double.toString(cpool.getDoubleAt(cpIndex)) + "D>";
        }
        if (ctag.isString() || ctag.isUnresolvedString()) {
            ConstantPool.CPSlot obj = cpool.getSlotAt(cpIndex);
            if (obj.isMetaData()) {
                Symbol sym = obj.getSymbol();
                return "<String \"" + sym.asString() + "\">";
            }
            if (obj.isOop()) {
                return "<String \"" + OopUtilities.stringOopToString(obj.getOop()) + "\">";
            }
            throw new RuntimeException("should not reach here");
        }
        if (ctag.isKlass() || ctag.isUnresolvedKlass()) {
            ConstantPool.CPSlot obj = cpool.getSlotAt(cpIndex);
            if (obj.isOop()) {
                Klass k = (Klass)obj.getOop();
                return "<Class " + k.getName().asString() + "@" + k.getHandle() + ">";
            }
            if (obj.isMetaData()) {
                Symbol sym = obj.getSymbol();
                return "<Class " + sym.asString() + ">";
            }
            throw new RuntimeException("should not reach here");
        }
        if (ctag.isMethodHandle()) {
            Oop x = this.getCachedConstant();
            int refidx = cpool.getMethodHandleIndexAt(cpIndex);
            int refkind = cpool.getMethodHandleRefKindAt(cpIndex);
            return "<MethodHandle kind=" + Integer.toString(refkind) + " ref=" + Integer.toString(refidx) + (x == null ? "" : " @" + x.getHandle()) + ">";
        }
        if (ctag.isMethodType()) {
            Oop x = this.getCachedConstant();
            int refidx = cpool.getMethodTypeIndexAt(cpIndex);
            return "<MethodType " + cpool.getSymbolAt(refidx).asString() + (x == null ? "" : " @" + x.getHandle()) + ">";
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(false, "invalid load constant type");
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getJavaBytecodeName());
        buf.append(" ");
        buf.append('#');
        buf.append(Integer.toString(this.poolIndex()));
        if (this.hasCacheIndex()) {
            buf.append('(');
            buf.append(Integer.toString(this.cacheIndex()));
            buf.append(')');
        }
        buf.append(" ");
        buf.append(this.getConstantValue());
        if (this.code() != this.javaCode()) {
            buf.append(" ");
            buf.append('[');
            buf.append(this.getBytecodeName());
            buf.append(']');
        }
        return buf.toString();
    }
}

