/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.jmx.json;

import com.oracle.javafx.jmx.json.JSONDocument;
import com.oracle.javafx.jmx.json.impl.JSONMessages;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class JSONWriter {
    private final Writer writer;
    private Stack<Container> where = new Stack();

    JSONWriter(Writer writer) {
        this.writer = writer;
    }

    public JSONWriter startObject() throws IOException {
        this.writeSeparatorIfNeeded();
        this.writer.write("{");
        this.where.push(new Container(ContainerType.OBJECT));
        return this;
    }

    public JSONWriter startObject(String key) throws IOException {
        if (this.where.peek().type != ContainerType.OBJECT) {
            throw new IllegalStateException(JSONMessages.localize(null, "not_inside_object"));
        }
        this.writeSeparatorIfNeeded();
        this.writeEscapedString(key);
        this.writer.write(":{");
        this.where.push(new Container(ContainerType.OBJECT));
        return this;
    }

    public JSONWriter endObject() throws IOException {
        if (this.where.peek().type != ContainerType.OBJECT) {
            throw new IllegalStateException(JSONMessages.localize(null, "mismatched_call_to_endObject"));
        }
        this.where.pop();
        this.writer.write("}");
        return this;
    }

    public JSONWriter startArray() throws IOException {
        this.writeSeparatorIfNeeded();
        this.writer.write("[");
        this.where.push(new Container(ContainerType.ARRAY));
        return this;
    }

    public JSONWriter startArray(String key) throws IOException {
        if (this.where.peek().type != ContainerType.OBJECT) {
            throw new IllegalStateException(JSONMessages.localize(null, "not_inside_object"));
        }
        this.writeSeparatorIfNeeded();
        this.writeEscapedString(key);
        this.writer.write(":[");
        this.where.push(new Container(ContainerType.ARRAY));
        return this;
    }

    public JSONWriter endArray() throws IOException {
        if (this.where.peek().type != ContainerType.ARRAY) {
            throw new IllegalStateException(JSONMessages.localize(null, "mismatched_call_to_endArray"));
        }
        this.writer.write("]");
        this.where.pop();
        return this;
    }

    public JSONWriter objectValue(String key, Object value) throws IOException {
        if (this.where.peek().type != ContainerType.OBJECT) {
            throw new IllegalStateException(JSONMessages.localize(null, "not_inside_object"));
        }
        this.writeSeparatorIfNeeded();
        this.writeEscapedString(key);
        this.writer.write(":");
        this.writeValue(value);
        return this;
    }

    public JSONWriter arrayValue(Object value) throws IOException {
        if (this.where.peek().type != ContainerType.ARRAY) {
            throw new IllegalStateException(JSONMessages.localize(null, "not_inside_array"));
        }
        this.writeSeparatorIfNeeded();
        this.writeValue(value);
        return this;
    }

    public JSONWriter writeObject(Map<String, Object> values) throws IOException {
        this.startObject();
        for (Map.Entry<String, Object> value : values.entrySet()) {
            this.objectValue(value.getKey(), value.getValue());
        }
        this.endObject();
        return this;
    }

    public JSONWriter writeArray(List<Object> values) throws IOException {
        this.startArray();
        for (Object value : values) {
            this.arrayValue(value);
        }
        this.endArray();
        return this;
    }

    public JSONWriter flush() throws IOException {
        this.writer.flush();
        return this;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    private void writeValue(Object value) throws IOException {
        if (value == null) {
            this.writer.write("null");
        } else if (value instanceof Map) {
            this.startObject();
            for (Map.Entry e : ((Map)value).entrySet()) {
                this.objectValue((String)e.getKey(), e.getValue());
            }
            this.endObject();
        } else if (value instanceof List) {
            this.startArray();
            Iterator ai = ((List)value).iterator();
            while (ai.hasNext()) {
                this.arrayValue(ai.next());
            }
            this.endArray();
        } else if (value instanceof String) {
            this.writeEscapedString((String)value);
        } else {
            this.writer.write(value.toString());
        }
    }

    private void writeSeparatorIfNeeded() throws IOException {
        if (this.where.empty()) {
            return;
        }
        if (this.where.peek().first) {
            this.where.peek().first = false;
        } else {
            this.writer.write(",");
        }
    }

    private void writeEscapedString(String value) throws IOException {
        this.writer.write("\"");
        JSONDocument.printEscapedString(this.writer, value);
        this.writer.write("\"");
    }

    private static class Container {
        ContainerType type;
        boolean first;

        Container(ContainerType type) {
            this.type = type;
            this.first = true;
        }
    }

    private static enum ContainerType {
        ARRAY,
        OBJECT;

    }
}

