/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.drt;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.webkit.drt.EventSender;
import com.sun.javafx.webkit.drt.UIClientImpl;
import com.sun.webkit.BackForwardList;
import com.sun.webkit.Invoker;
import com.sun.webkit.LoadListenerClient;
import com.sun.webkit.PageCache;
import com.sun.webkit.ThemeClient;
import com.sun.webkit.WebPage;
import com.sun.webkit.WebPageClient;
import com.sun.webkit.graphics.Ref;
import com.sun.webkit.graphics.RenderTheme;
import com.sun.webkit.graphics.ScrollBarTheme;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCPageBackBuffer;
import com.sun.webkit.graphics.WCPoint;
import com.sun.webkit.graphics.WCRectangle;
import com.sun.webkit.graphics.WCSize;
import com.sun.webkit.network.URLs;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javafx.scene.web.WebEngine;

public final class DumpRenderTree {
    private static final Logger log = Logger.getLogger("DumpRenderTree");
    private static final long PID = new Date().getTime() & 0xFFFFL;
    private static final String fileSep = System.getProperty("file.separator");
    private static boolean forceDumpAsText = false;
    static final PrintWriter out;
    static volatile DumpRenderTree drt;
    private final WebPage webPage;
    private final UIClientImpl uiClient = new UIClientImpl();
    private final EventSender eventSender;
    private CountDownLatch latch;
    private String testPath;
    private boolean loaded;
    private boolean waiting;
    private boolean complete;
    private static final String TEST_DIR_NAME = "LayoutTests";
    private static final int TEST_DIR_LEN;
    private static final String CUR_ITEM_STR = "curr->";
    private static final int CUR_ITEM_STR_LEN;
    private static final String INDENT = "    ";
    private BackForwardList bfl;

    private DumpRenderTree() {
        this.webPage = new WebPage(new WebPageClientImpl(), this.uiClient, null, null, new ThemeClientImplStub(), false);
        this.uiClient.setWebPage(this.webPage);
        this.eventSender = new EventSender(this.webPage);
        this.webPage.setBounds(0, 0, 800, 600);
        this.webPage.setUsePageCache(true);
        this.webPage.setDeveloperExtrasEnabled(true);
        this.webPage.addLoadListenerClient(new DRTLoadListener());
    }

    private String getTestPath(String testString) {
        int t = testString.indexOf("'");
        String pixelsHash = "";
        if (t > 0 && t < testString.length() - 1) {
            pixelsHash = testString.substring(t + 1);
            testString = testString.substring(0, t);
        }
        this.testPath = testString;
        DumpRenderTree.init(testString, pixelsHash);
        return testString;
    }

    private static boolean isDebug() {
        return log.isLoggable(Level.FINE);
    }

    private static void mlog(String msg) {
        if (DumpRenderTree.isDebug()) {
            log.fine("PID:" + Long.toHexString(PID) + " TID:" + Thread.currentThread().getId() + "(" + Thread.currentThread().getName() + ") " + msg);
        }
    }

    private static void initPlatform() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        PlatformImpl.startup(() -> {
            new WebEngine();
            System.loadLibrary("DumpRenderTreeJava");
            PageCache.setCapacity(1);
            drt = new DumpRenderTree();
            latch.countDown();
        });
        latch.await();
    }

    private void reset() {
        DumpRenderTree.mlog("reset");
        this.webPage.resetToConsistentStateBeforeTesting();
        this.webPage.setZoomFactor(1.0f, true);
        this.webPage.setZoomFactor(1.0f, false);
        this.complete = false;
        this.loaded = false;
        this.waiting = false;
    }

    private void run(String testString, CountDownLatch latch) {
        this.latch = latch;
        String file = this.getTestPath(testString);
        DumpRenderTree.mlog("{runTest: " + file);
        long mainFrame = this.webPage.getMainFrame();
        try {
            new URL(file);
        }
        catch (MalformedURLException ex) {
            file = "file:///" + file;
        }
        this.reset();
        this.webPage.open(mainFrame, file);
        DumpRenderTree.mlog("}runTest");
    }

    private void runTest(String testString) throws Exception {
        CountDownLatch l = new CountDownLatch(1);
        Invoker.getInvoker().invokeOnEventThread(() -> this.run(testString, l));
        l.await();
        Invoker.getInvoker().invokeOnEventThread(() -> {
            DumpRenderTree.mlog("dispose");
            DumpRenderTree.dispose();
        });
    }

    private static void waitUntilDone() {
        DumpRenderTree.mlog("waitUntilDone");
        drt.setWaiting(true);
    }

    private static void notifyDone() {
        DumpRenderTree.mlog("notifyDone");
        drt.setWaiting(false);
    }

    private static void overridePreference(String key, String value) {
        DumpRenderTree.mlog("overridePreference");
        DumpRenderTree.drt.webPage.overridePreference(key, value);
    }

    private synchronized void setLoaded(boolean loaded) {
        this.loaded = loaded;
        this.done();
    }

    private synchronized void setWaiting(boolean waiting) {
        this.waiting = waiting;
        this.done();
    }

    private synchronized void dump(long frame) {
        boolean dumpAsText = DumpRenderTree.dumpAsText() || forceDumpAsText;
        DumpRenderTree.mlog("dumpAsText = " + dumpAsText);
        if (dumpAsText) {
            List<Long> children;
            String innerText = this.webPage.getInnerText(frame);
            if (frame == this.webPage.getMainFrame()) {
                if (innerText != null) {
                    out.print(innerText + '\n');
                }
            } else {
                out.printf("\n--------\nFrame: '%s'\n--------\n%s\n", this.webPage.getName(frame), innerText);
            }
            if (DumpRenderTree.dumpChildFramesAsText() && (children = this.webPage.getChildFrames(frame)) != null) {
                for (long child : children) {
                    this.dump(child);
                }
            }
            if (DumpRenderTree.dumpBackForwardList() && frame == this.webPage.getMainFrame()) {
                drt.dumpBfl();
            }
        } else {
            String renderTree = this.webPage.getRenderTree(frame);
            out.print(renderTree);
        }
    }

    private synchronized void done() {
        if (this.waiting || !this.loaded || this.complete) {
            return;
        }
        DumpRenderTree.mlog("dump");
        this.dump(this.webPage.getMainFrame());
        DumpRenderTree.mlog("done");
        out.print("#EOF\n");
        out.print("#EOF\n");
        out.flush();
        System.err.print("#EOF\n");
        System.err.flush();
        this.complete = true;
        this.latch.countDown();
    }

    private static native void init(String var0, String var1);

    private static native void didClearWindowObject(long var0, long var2, EventSender var4);

    private static native void dispose();

    private static native boolean dumpAsText();

    private static native boolean dumpChildFramesAsText();

    private static native boolean dumpBackForwardList();

    public static void main(String[] args) throws Exception {
        if (DumpRenderTree.isDebug()) {
            log.setLevel(Level.FINEST);
            FileHandler handler = new FileHandler("drt.log", true);
            handler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return this.formatMessage(record) + "\n";
                }
            });
            log.addHandler(handler);
        }
        DumpRenderTree.mlog("{main");
        DumpRenderTree.initPlatform();
        assert (drt != null);
        for (String arg : args) {
            if ("--dump-as-text".equals(arg)) {
                forceDumpAsText = true;
                continue;
            }
            if ("-".equals(arg)) {
                String testPath;
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                while ((testPath = in.readLine()) != null) {
                    drt.runTest(testPath);
                }
                in.close();
                continue;
            }
            drt.runTest(arg);
        }
        PlatformImpl.exit();
        DumpRenderTree.mlog("}main");
        System.exit(0);
    }

    private static int getWorkerThreadCount() {
        DumpRenderTree dumpRenderTree = drt;
        return dumpRenderTree.webPage.getWorkerThreadCount();
    }

    private static String resolveURL(String relativeURL) {
        String testDir = new File(DumpRenderTree.drt.testPath).getParentFile().getPath();
        File f = new File(testDir, relativeURL);
        String url = "file:///" + f.toString().replace(fileSep, "/");
        DumpRenderTree.mlog("resolveURL: " + url);
        return url;
    }

    private static void loadURL(String url) {
        DumpRenderTree.drt.webPage.open(DumpRenderTree.drt.webPage.getMainFrame(), url);
    }

    private static void goBackForward(int dist) {
        if (dist > 0) {
            DumpRenderTree.drt.webPage.goForward();
        } else {
            DumpRenderTree.drt.webPage.goBack();
        }
    }

    private static int getBackForwardItemCount() {
        return drt.getBackForwardList().size();
    }

    private BackForwardList getBackForwardList() {
        if (this.bfl == null) {
            this.bfl = this.webPage.createBackForwardList();
        }
        return this.bfl;
    }

    private void dumpBfl() {
        out.print("\n============== Back Forward List ==============\n");
        this.getBackForwardList();
        BackForwardList.Entry curItem = this.bfl.getCurrentEntry();
        for (BackForwardList.Entry e : this.bfl.toArray()) {
            this.dumpBflItem(e, 2, e == curItem);
        }
        out.print("===============================================\n");
    }

    private void dumpBflItem(BackForwardList.Entry item, int indent, boolean isCurrent) {
        String url;
        StringBuilder str = new StringBuilder();
        for (int i = indent; i > 0; --i) {
            str.append(INDENT);
        }
        if (isCurrent) {
            str.replace(0, CUR_ITEM_STR_LEN, CUR_ITEM_STR);
        }
        if ((url = item.getURL().toString()).contains("file:/")) {
            String subUrl = url.substring(url.indexOf(TEST_DIR_NAME) + TEST_DIR_LEN + 1);
            str.append("(file test):" + subUrl);
        } else {
            str.append(url);
        }
        if (item.getTarget() != null) {
            str.append(" (in frame \"" + item.getTarget() + "\")");
        }
        if (item.isTargetItem()) {
            str.append("  **nav target**\n");
        } else {
            str.append("\n");
        }
        out.print(str);
        if (item.getChildren() != null) {
            for (BackForwardList.Entry child : item.getChildren()) {
                this.dumpBflItem(child, indent + 1, false);
            }
        }
    }

    void dumpUnloadListeners(WebPage page, long frame) {
        String dump;
        if (this.waiting && DumpRenderTree.dumpAsText() && (dump = DumpRenderTree.getUnloadListenersDescription(page, frame)) != null) {
            out.print(dump + '\n');
        }
    }

    private static String getUnloadListenersDescription(WebPage page, long frame) {
        int count = page.getUnloadEventListenersCount(frame);
        if (count > 0) {
            return DumpRenderTree.getFrameDescription(page, frame) + " - has " + count + " onunload handler(s)";
        }
        return null;
    }

    private static String getFrameDescription(WebPage page, long frame) {
        String name = page.getName(frame);
        if (frame == page.getMainFrame()) {
            return name == null ? "main frame" : "main frame " + name;
        }
        return name == null ? "frame (anonymous)" : "frame " + name;
    }

    private static native boolean didFinishLoad();

    static {
        try {
            out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8")), true);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        TEST_DIR_LEN = TEST_DIR_NAME.length();
        CUR_ITEM_STR_LEN = CUR_ITEM_STR.length();
    }

    private final class WebPageClientImpl
    implements WebPageClient<Void> {
        private WebPageClientImpl() {
        }

        @Override
        public void setCursor(long cursorID) {
        }

        @Override
        public void setFocus(boolean focus) {
        }

        @Override
        public void transferFocus(boolean forward) {
        }

        @Override
        public void setTooltip(String tooltip) {
        }

        @Override
        public WCRectangle getScreenBounds(boolean available) {
            return null;
        }

        @Override
        public int getScreenDepth() {
            return 24;
        }

        @Override
        public Void getContainer() {
            return null;
        }

        @Override
        public WCPoint screenToWindow(WCPoint ptScreen) {
            return ptScreen;
        }

        @Override
        public WCPoint windowToScreen(WCPoint ptWindow) {
            return ptWindow;
        }

        @Override
        public WCPageBackBuffer createBackBuffer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isBackBufferSupported() {
            return false;
        }

        @Override
        public void addMessageToConsole(String message, int lineNumber, String sourceId) {
            int pos;
            if (!message.isEmpty() && (pos = message.indexOf("file://")) != -1) {
                String s1 = message.substring(0, pos);
                String s2 = message.substring(pos);
                try {
                    s2 = new File(URLs.newURL(s2).getPath()).getName();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                message = s1 + s2;
            }
            if (lineNumber == 0) {
                out.printf("CONSOLE MESSAGE: %s\n", message);
            } else {
                out.printf("CONSOLE MESSAGE: line %d: %s\n", lineNumber, message);
            }
        }

        @Override
        public void didClearWindowObject(long context, long windowObject) {
            DumpRenderTree.mlog("didClearWindowObject");
            DumpRenderTree.didClearWindowObject(context, windowObject, DumpRenderTree.this.eventSender);
        }
    }

    private final class DRTLoadListener
    implements LoadListenerClient {
        private DRTLoadListener() {
        }

        @Override
        public void dispatchLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
            DumpRenderTree.mlog("dispatchLoadEvent: ENTER");
            if (frame == DumpRenderTree.this.webPage.getMainFrame()) {
                DumpRenderTree.mlog("dispatchLoadEvent: STATE = " + state);
                switch (state) {
                    case 0: {
                        DumpRenderTree.mlog("PAGE_STARTED");
                        DumpRenderTree.this.setLoaded(false);
                        break;
                    }
                    case 1: {
                        DumpRenderTree.mlog("PAGE_FINISHED");
                        if (!DumpRenderTree.didFinishLoad()) break;
                        DumpRenderTree.this.setLoaded(true);
                        break;
                    }
                    case 14: {
                        DumpRenderTree.this.dumpUnloadListeners(DumpRenderTree.this.webPage, frame);
                        break;
                    }
                    case 5: {
                        DumpRenderTree.mlog("LOAD_FAILED");
                        DumpRenderTree.this.setLoaded(true);
                    }
                }
            }
            DumpRenderTree.mlog("dispatchLoadEvent: EXIT");
        }

        @Override
        public void dispatchResourceLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
        }
    }

    class ScrollBarThemeStub
    extends ScrollBarTheme {
        ScrollBarThemeStub() {
        }

        @Override
        protected Ref createWidget(long id, int w, int h, int orientation, int value, int visibleSize, int totalSize) {
            return null;
        }

        @Override
        protected void getScrollBarPartRect(long id, int part, int[] rect) {
        }

        @Override
        public void paint(WCGraphicsContext g, Ref sbRef, int x, int y, int pressedPart, int hoveredPart) {
        }

        @Override
        public WCSize getWidgetSize(Ref widget) {
            return new WCSize(0.0f, 0.0f);
        }
    }

    class RenderThemeStub
    extends RenderTheme {
        RenderThemeStub() {
        }

        @Override
        protected Ref createWidget(long id, int widgetIndex, int state, int w, int h, int bgColor, ByteBuffer extParams) {
            return null;
        }

        @Override
        public void drawWidget(WCGraphicsContext g, Ref widget, int x, int y) {
        }

        @Override
        protected int getRadioButtonSize() {
            return 0;
        }

        @Override
        protected int getSelectionColor(int index) {
            return 0;
        }

        @Override
        public WCSize getWidgetSize(Ref widget) {
            return new WCSize(0.0f, 0.0f);
        }
    }

    class ThemeClientImplStub
    extends ThemeClient {
        ThemeClientImplStub() {
        }

        @Override
        protected RenderTheme createRenderTheme() {
            return new RenderThemeStub();
        }

        @Override
        protected ScrollBarTheme createScrollBarTheme() {
            return new ScrollBarThemeStub();
        }
    }
}

