#ifndef _EFL_UI_VIEW_LIST_SEGARRAY_EO_H_
#define _EFL_UI_VIEW_LIST_SEGARRAY_EO_H_

#ifndef _EFL_UI_VIEW_LIST_SEGARRAY_EO_CLASS_TYPE
#define _EFL_UI_VIEW_LIST_SEGARRAY_EO_CLASS_TYPE

typedef Eo Efl_Ui_View_List_SegArray;

#endif

#ifndef _EFL_UI_VIEW_LIST_SEGARRAY_EO_TYPES
#define _EFL_UI_VIEW_LIST_SEGARRAY_EO_TYPES


#endif
#define EFL_UI_VIEW_LIST_SEGARRAY_CLASS efl_ui_view_list_segarray_class_get()

EWAPI const Efl_Class *efl_ui_view_list_segarray_class_get(void);

/** Get a SegArray List items accessor
 *
 * @ingroup Efl_Ui_View_List_SegArray
 */
EOAPI Eina_Accessor *efl_ui_view_list_segarray_accessor_get(const Eo *obj);

/** Get a SegArray node accessor
 *
 * @ingroup Efl_Ui_View_List_SegArray
 */
EOAPI Eina_Accessor *efl_ui_view_list_segarray_node_accessor_get(const Eo *obj);

/**
 * @brief Insert a accessor in segarray tree
 *
 * @param[in] obj The object.
 * @param[in] first
 * @param[in] v
 *
 * @ingroup Efl_Ui_View_List_SegArray
 */
EOAPI void efl_ui_view_list_segarray_insert_value(Eo *obj, int first, Eina_Value v);

/** Get the number of items in SegArray tree
 *
 * @ingroup Efl_Ui_View_List_SegArray
 */
EOAPI int efl_ui_view_list_segarray_count(Eo *obj);

/**
 * @brief Configure a step of SegArray tree, this is the max node size
 *
 * @param[in] obj The object.
 * @param[in] initial_step_size
 *
 * @ingroup Efl_Ui_View_List_SegArray
 */
EOAPI void efl_ui_view_list_segarray_setup(Eo *obj, int initial_step_size);

/** flush the SegArray tree
 *
 * @ingroup Efl_Ui_View_List_SegArray
 */
EOAPI void efl_ui_view_list_segarray_flush(Eo *obj);

/**
 * @brief Insert a new model in SegArray tree at index position
 *
 * @param[in] obj The object.
 * @param[in] index
 * @param[in] model
 *
 * @ingroup Efl_Ui_View_List_SegArray
 */
EOAPI void efl_ui_view_list_segarray_insert(Eo *obj, int index, Efl_Model *model);

/**
 * @brief Remove the item at index position in SegArray tree
 *
 * @param[in] obj The object.
 * @param[in] index
 *
 * @ingroup Efl_Ui_View_List_SegArray
 */
EOAPI Efl_Ui_View_List_LayoutItem *efl_ui_view_list_segarray_remove(Eo *obj, int index);

#endif
