#ifndef _EFL_UI_SCROLLBAR_EO_H_
#define _EFL_UI_SCROLLBAR_EO_H_

#ifndef _EFL_UI_SCROLLBAR_EO_CLASS_TYPE
#define _EFL_UI_SCROLLBAR_EO_CLASS_TYPE

typedef Eo Efl_Ui_Scrollbar;

#endif

#ifndef _EFL_UI_SCROLLBAR_EO_TYPES
#define _EFL_UI_SCROLLBAR_EO_TYPES

typedef enum
{
  EFL_UI_SCROLLBAR_MODE_AUTO = 0, /**< Visible if necessary */
  EFL_UI_SCROLLBAR_MODE_ON, /**< Always visible */
  EFL_UI_SCROLLBAR_MODE_OFF, /**< Always invisible */
  EFL_UI_SCROLLBAR_MODE_LAST /**< No description supplied. */
} Efl_Ui_Scrollbar_Mode;

typedef enum
{
  EFL_UI_SCROLLBAR_DIRECTION_HORIZONTAL = 0,
  EFL_UI_SCROLLBAR_DIRECTION_VERTICAL,
  EFL_UI_SCROLLBAR_DIRECTION_LAST
} Efl_Ui_Scrollbar_Direction;


#endif
#define EFL_UI_SCROLLBAR_INTERFACE efl_ui_scrollbar_interface_get()

EWAPI const Efl_Class *efl_ui_scrollbar_interface_get(void);

/**
 * @brief Scrollbar visibility policy
 *
 * @param[in] obj The object.
 * @param[in] hbar Horizontal scrollbar
 * @param[in] vbar Vertical scrollbar
 *
 * @ingroup Efl_Ui_Scrollbar
 */
EOAPI void efl_ui_scrollbar_bar_mode_set(Eo *obj, Efl_Ui_Scrollbar_Mode hbar, Efl_Ui_Scrollbar_Mode vbar);

/**
 * @brief Scrollbar visibility policy
 *
 * @param[in] obj The object.
 * @param[out] hbar Horizontal scrollbar
 * @param[out] vbar Vertical scrollbar
 *
 * @ingroup Efl_Ui_Scrollbar
 */
EOAPI void efl_ui_scrollbar_bar_mode_get(const Eo *obj, Efl_Ui_Scrollbar_Mode *hbar, Efl_Ui_Scrollbar_Mode *vbar);

/**
 * @brief Scrollbar size. It is calculated based on viewport size-content
 * sizes.
 *
 * @param[in] obj The object.
 * @param[out] width Value between 0.0 and 1.0
 * @param[out] height Value between 0.0 and 1.0
 *
 * @ingroup Efl_Ui_Scrollbar
 */
EOAPI void efl_ui_scrollbar_bar_size_get(const Eo *obj, double *width, double *height);

/**
 * @brief Scrollbar position. It is calculated based on current
 * position-maximum positions.
 *
 * @param[in] obj The object.
 * @param[in] posx Value between 0.0 and 1.0
 * @param[in] posy Value between 0.0 and 1.0
 *
 * @ingroup Efl_Ui_Scrollbar
 */
EOAPI void efl_ui_scrollbar_bar_position_set(Eo *obj, double posx, double posy);

/**
 * @brief Scrollbar position. It is calculated based on current
 * position-maximum positions.
 *
 * @param[in] obj The object.
 * @param[out] posx Value between 0.0 and 1.0
 * @param[out] posy Value between 0.0 and 1.0
 *
 * @ingroup Efl_Ui_Scrollbar
 */
EOAPI void efl_ui_scrollbar_bar_position_get(const Eo *obj, double *posx, double *posy);

#ifdef EFL_UI_SCROLLBAR_BETA
#ifdef EFL_UI_SCROLLBAR_PROTECTED
/**
 * @brief Update bar visibility.
 *
 * The object will call this function whenever the bar need to be shown or
 * hidden.
 * @param[in] obj The object.
 *
 * @ingroup Efl_Ui_Scrollbar
 */
EOAPI void efl_ui_scrollbar_bar_visibility_update(Eo *obj);
#endif
#endif

EWAPI extern const Efl_Event_Description _EFL_UI_SCROLLBAR_EVENT_BAR_PRESS;

/** Called when bar is pressed
 * @return Efl_Ui_Scrollbar_Direction
 *
 * @ingroup Efl_Ui_Scrollbar
 */
#define EFL_UI_SCROLLBAR_EVENT_BAR_PRESS (&(_EFL_UI_SCROLLBAR_EVENT_BAR_PRESS))

EWAPI extern const Efl_Event_Description _EFL_UI_SCROLLBAR_EVENT_BAR_UNPRESS;

/** Called when bar is unpressed
 * @return Efl_Ui_Scrollbar_Direction
 *
 * @ingroup Efl_Ui_Scrollbar
 */
#define EFL_UI_SCROLLBAR_EVENT_BAR_UNPRESS (&(_EFL_UI_SCROLLBAR_EVENT_BAR_UNPRESS))

EWAPI extern const Efl_Event_Description _EFL_UI_SCROLLBAR_EVENT_BAR_DRAG;

/** Called when bar is dragged
 * @return Efl_Ui_Scrollbar_Direction
 *
 * @ingroup Efl_Ui_Scrollbar
 */
#define EFL_UI_SCROLLBAR_EVENT_BAR_DRAG (&(_EFL_UI_SCROLLBAR_EVENT_BAR_DRAG))

EWAPI extern const Efl_Event_Description _EFL_UI_SCROLLBAR_EVENT_BAR_SIZE_CHANGED;

/** Called when bar size is changed
 *
 * @ingroup Efl_Ui_Scrollbar
 */
#define EFL_UI_SCROLLBAR_EVENT_BAR_SIZE_CHANGED (&(_EFL_UI_SCROLLBAR_EVENT_BAR_SIZE_CHANGED))

EWAPI extern const Efl_Event_Description _EFL_UI_SCROLLBAR_EVENT_BAR_POS_CHANGED;

/** Called when bar position is changed
 *
 * @ingroup Efl_Ui_Scrollbar
 */
#define EFL_UI_SCROLLBAR_EVENT_BAR_POS_CHANGED (&(_EFL_UI_SCROLLBAR_EVENT_BAR_POS_CHANGED))

EWAPI extern const Efl_Event_Description _EFL_UI_SCROLLBAR_EVENT_BAR_SHOW;

/** Callend when bar is shown
 * @return Efl_Ui_Scrollbar_Direction
 *
 * @ingroup Efl_Ui_Scrollbar
 */
#define EFL_UI_SCROLLBAR_EVENT_BAR_SHOW (&(_EFL_UI_SCROLLBAR_EVENT_BAR_SHOW))

EWAPI extern const Efl_Event_Description _EFL_UI_SCROLLBAR_EVENT_BAR_HIDE;

/** Called when bar is hidden
 * @return Efl_Ui_Scrollbar_Direction
 *
 * @ingroup Efl_Ui_Scrollbar
 */
#define EFL_UI_SCROLLBAR_EVENT_BAR_HIDE (&(_EFL_UI_SCROLLBAR_EVENT_BAR_HIDE))

#endif
