#ifndef EFL_TASK_EO_HH
#define EFL_TASK_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_io_closer.eo.h"
#include "efl_io_reader.eo.h"
#include "efl_io_writer.eo.h"
#include "efl_object.eo.h"
#include "efl_task.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
#include "efl_io_closer.eo.hh"
#include "efl_io_reader.eo.hh"
#include "efl_io_writer.eo.hh"
#include "efl_object.eo.hh"
#ifndef EFL_TASK_FWD_GUARD
#define EFL_TASK_FWD_GUARD
namespace efl { 
struct Task;
} 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Task> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Task&> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Task const> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Task const&> : ::std::true_type {}; } }
#endif
#ifndef EFL_IO_CLOSER_FWD_GUARD
#define EFL_IO_CLOSER_FWD_GUARD
namespace efl { namespace io { 
struct Closer;
} } 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Closer> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Closer&> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Closer const> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Closer const&> : ::std::true_type {}; } }
#endif
#ifndef EFL_OBJECT_FWD_GUARD
#define EFL_OBJECT_FWD_GUARD
namespace efl { 
struct Object;
} 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Object> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Object&> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Object const> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Object const&> : ::std::true_type {}; } }
#endif
#ifndef EFL_IO_READER_FWD_GUARD
#define EFL_IO_READER_FWD_GUARD
namespace efl { namespace io { 
struct Reader;
} } 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Reader> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Reader&> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Reader const> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Reader const&> : ::std::true_type {}; } }
#endif
#ifndef EFL_IO_WRITER_FWD_GUARD
#define EFL_IO_WRITER_FWD_GUARD
namespace efl { namespace io { 
struct Writer;
} } 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Writer> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Writer&> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Writer const> : ::std::true_type {}; } }
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Writer const&> : ::std::true_type {}; } }
#endif

namespace eo_cxx {
namespace efl { 
struct Task {
   ::efl::eolian::return_traits< ::efl::eina::string_view>::type command_get() const;
   ::efl::eolian::return_traits<void>::type command_set( ::efl::eolian::in_traits< ::efl::eina::string_view>::type command) const;
   ::efl::eolian::return_traits< unsigned int>::type arg_count_get() const;
   ::efl::eolian::return_traits< ::efl::eina::string_view>::type arg_value_get( ::efl::eolian::in_traits< unsigned int>::type num) const;
   ::efl::eolian::return_traits<void>::type arg_value_set( ::efl::eolian::in_traits< unsigned int>::type num,  ::efl::eolian::in_traits< ::efl::eina::string_view>::type arg) const;
   ::efl::eolian::return_traits< ::efl::eina::string_view>::type env_get( ::efl::eolian::in_traits< ::efl::eina::string_view>::type var) const;
   ::efl::eolian::return_traits<void>::type env_set( ::efl::eolian::in_traits< ::efl::eina::string_view>::type var,  ::efl::eolian::in_traits< ::efl::eina::string_view>::type value) const;
   ::efl::eolian::return_traits<Efl_Task_Priority>::type priority_get() const;
   ::efl::eolian::return_traits<void>::type priority_set( ::efl::eolian::in_traits<Efl_Task_Priority>::type priority) const;
   ::efl::eolian::return_traits<int>::type exit_code_get() const;
   ::efl::eolian::return_traits<Efl_Task_Flags>::type flags_get() const;
   ::efl::eolian::return_traits<void>::type flags_set( ::efl::eolian::in_traits<Efl_Task_Flags>::type flags) const;
   ::efl::eolian::return_traits<void>::type arg_append( ::efl::eolian::in_traits< ::efl::eina::string_view>::type arg) const;
   ::efl::eolian::return_traits<void>::type arg_reset() const;
   ::efl::eolian::return_traits<void>::type env_reset() const;
   ::efl::eolian::return_traits<void>::type end() const;
   static Efl_Class const* _eo_class()
   {
      return EFL_TASK_CLASS;
   }
   Eo* _eo_ptr() const { return *(reinterpret_cast<Eo **>(const_cast<Task *>(this))); }
   operator ::efl::Task() const;
   operator ::efl::Task&();
   operator ::efl::Task const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Task,  ::efl::Object,  ::efl::io::Closer,  ::efl::io::Reader,  ::efl::io::Writer> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Task const ,  ::efl::Object const ,  ::efl::io::Closer const ,  ::efl::io::Reader const ,  ::efl::io::Writer const > operator&() const { return {this}; }
   /// @endcond
};
} 
}
namespace efl { 
struct Task : private ::efl::eo::concrete
   , EO_CXX_INHERIT(::efl::Object)
   , EO_CXX_INHERIT(::efl::io::Closer)
   , EO_CXX_INHERIT(::efl::io::Reader)
   , EO_CXX_INHERIT(::efl::io::Writer)
{
   explicit Task( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   Task(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   explicit Task() = default;
   Task(Task const&) = default;
   Task(Task&&) = default;
   Task& operator=(Task const&) = default;
   Task& operator=(Task&&) = default;
   template <typename Derived>
   Task(Derived&& derived
      , typename std::enable_if<
         ::efl::eo::is_eolian_object<Derived>::value
          && std::is_base_of< Task, Derived>::value>::type* = 0)
         : ::efl::eo::concrete(derived._eo_ptr()) {}

   Task( ::efl::eo::instantiate_t)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   template <typename T>
   explicit Task( ::efl::eo::instantiate_t, T&& parent, typename std::enable_if< ::efl::eo::is_eolian_object<T>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Task( ::efl::eo::instantiate_t, F&& f, typename ::std::enable_if< ::efl::eolian::is_constructor_lambda<F, Task >::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), *this, std::forward<F>(f));
   }
   template <typename T, typename F> Task(  ::efl::eo::instantiate_t, T&& parent, F&& f, typename ::std::enable_if< ::efl::eolian::is_constructor_lambda<F, Task >::value && ::efl::eo::is_eolian_object<T>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class(), *this, std::forward<F>(f));
   }

   ::efl::eolian::return_traits< ::efl::eina::string_view>::type command_get() const;
   ::efl::eolian::return_traits<void>::type command_set( ::efl::eolian::in_traits< ::efl::eina::string_view>::type command) const;
   ::efl::eolian::return_traits< unsigned int>::type arg_count_get() const;
   ::efl::eolian::return_traits< ::efl::eina::string_view>::type arg_value_get( ::efl::eolian::in_traits< unsigned int>::type num) const;
   ::efl::eolian::return_traits<void>::type arg_value_set( ::efl::eolian::in_traits< unsigned int>::type num,  ::efl::eolian::in_traits< ::efl::eina::string_view>::type arg) const;
   ::efl::eolian::return_traits< ::efl::eina::string_view>::type env_get( ::efl::eolian::in_traits< ::efl::eina::string_view>::type var) const;
   ::efl::eolian::return_traits<void>::type env_set( ::efl::eolian::in_traits< ::efl::eina::string_view>::type var,  ::efl::eolian::in_traits< ::efl::eina::string_view>::type value) const;
   ::efl::eolian::return_traits<Efl_Task_Priority>::type priority_get() const;
   ::efl::eolian::return_traits<void>::type priority_set( ::efl::eolian::in_traits<Efl_Task_Priority>::type priority) const;
   ::efl::eolian::return_traits<int>::type exit_code_get() const;
   ::efl::eolian::return_traits<Efl_Task_Flags>::type flags_get() const;
   ::efl::eolian::return_traits<void>::type flags_set( ::efl::eolian::in_traits<Efl_Task_Flags>::type flags) const;
   ::efl::eolian::return_traits<void>::type arg_append( ::efl::eolian::in_traits< ::efl::eina::string_view>::type arg) const;
   ::efl::eolian::return_traits<void>::type arg_reset() const;
   ::efl::eolian::return_traits<void>::type env_reset() const;
   ::efl::eolian::return_traits<void>::type end() const;
   static Efl_Class const* _eo_class()
   {
      return EFL_TASK_CLASS;
   }
   Eo* _eo_ptr() const { return *(reinterpret_cast<Eo **>(const_cast<Task *>(this))); }
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Task,  ::efl::Object,  ::efl::io::Closer,  ::efl::io::Reader,  ::efl::io::Writer> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Task const ,  ::efl::Object const ,  ::efl::io::Closer const ,  ::efl::io::Reader const ,  ::efl::io::Writer const > operator&() const { return {this}; }
   /// @endcond
   ::efl::eo::wref<Task> _get_wref() const { return ::efl::eo::wref<Task>(*this); }
   ::efl::eo::concrete const& _get_concrete() const { return *this; }
   ::efl::eo::concrete& _get_concrete() { return *this; }
   using ::efl::eo::concrete::_eo_ptr;
   using ::efl::eo::concrete::_release;
   using ::efl::eo::concrete::_reset;
   using ::efl::eo::concrete::_delete;
   using ::efl::eo::concrete::operator bool;
#ifdef EFL_CXXPERIMENTAL
   const Task* operator->() const { return this; }
   Task* operator->() { return this; }
   operator Eo*() const { return _eo_ptr(); }
#endif 
   friend bool operator==(Task const& lhs, Task const& rhs)
   { return lhs._get_concrete() == rhs._get_concrete(); }
   friend bool operator!=(Task const& lhs, Task const& rhs)
   { return !(lhs == rhs); }
};
static_assert(sizeof(Task) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Task>::value, "");
} 
#endif
