#ifndef _EFL_MODEL_COMPOSITE_BOOLEAN_EO_H_
#define _EFL_MODEL_COMPOSITE_BOOLEAN_EO_H_

#ifndef _EFL_MODEL_COMPOSITE_BOOLEAN_EO_CLASS_TYPE
#define _EFL_MODEL_COMPOSITE_BOOLEAN_EO_CLASS_TYPE

typedef Eo Efl_Model_Composite_Boolean;

#endif

#ifndef _EFL_MODEL_COMPOSITE_BOOLEAN_EO_TYPES
#define _EFL_MODEL_COMPOSITE_BOOLEAN_EO_TYPES


#endif
/** Efl model composite boolean class
 *
 * @ingroup Efl_Model_Composite_Boolean
 */
#define EFL_MODEL_COMPOSITE_BOOLEAN_CLASS efl_model_composite_boolean_class_get()

EWAPI const Efl_Class *efl_model_composite_boolean_class_get(void);

/**
 * @brief Add a new named boolean property with a defined default value.
 *
 * @param[in] obj The object.
 * @param[in] name
 * @param[in] default_value
 *
 * @ingroup Efl_Model_Composite_Boolean
 */
EOAPI void efl_model_composite_boolean_add(Eo *obj, const char *name, Eina_Bool default_value);

/**
 * @brief Delete an existing named boolean property
 *
 * @param[in] obj The object.
 * @param[in] name
 *
 * @ingroup Efl_Model_Composite_Boolean
 */
EOAPI void efl_model_composite_boolean_del(Eo *obj, const char *name);

#endif
