/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPPacket;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTCPBYEPacket
extends RTCPPacket {
    int[] ssrc;
    byte[] reason;

    public RTCPBYEPacket(RTCPPacket parent) {
        super(parent);
        this.type = 203;
    }

    public RTCPBYEPacket(int[] ssrc, byte[] reason) {
        this.ssrc = ssrc;
        this.reason = reason != null ? reason : new byte[0];
        if (ssrc.length > 31) {
            throw new IllegalArgumentException("Too many SSRCs");
        }
    }

    public String toString() {
        return "\tRTCP BYE packet for sync source(s) " + this.toString(this.ssrc) + " for " + (this.reason.length > 0 ? "reason " + new String(this.reason) : "no reason") + "\n";
    }

    public String toString(int[] ints) {
        if (ints.length == 0) {
            return "(none)";
        }
        String s = "" + ints[0];
        int i = 1;
        while (i < ints.length) {
            s = s + ", " + ints[i];
            ++i;
        }
        return s;
    }

    public int calcLength() {
        return 4 + (this.ssrc.length << 2) + (this.reason.length > 0 ? this.reason.length + 4 & 0xFFFFFFFC : 0);
    }

    void assemble(DataOutputStream out) throws IOException {
        out.writeByte(128 + this.ssrc.length);
        out.writeByte(203);
        out.writeShort(this.ssrc.length + (this.reason.length > 0 ? this.reason.length + 4 >> 2 : 0));
        int i = 0;
        while (i < this.ssrc.length) {
            out.writeInt(this.ssrc[i]);
            ++i;
        }
        if (this.reason.length > 0) {
            out.writeByte(this.reason.length);
            out.write(this.reason);
            int i2 = (this.reason.length + 4 & 0xFFFFFFFC) - this.reason.length - 1;
            while (i2 > 0) {
                out.writeByte(0);
                --i2;
            }
        }
    }
}

