/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyqt;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QtFileType
extends LanguageFileType
implements INativeFileType {
    private final String myName;
    private final String myDescription;
    private final String myDefaultExtension;
    private final Icon myIcon;

    protected QtFileType(String name, String description, String defaultExtension, Icon icon) {
        super((Language)XMLLanguage.INSTANCE);
        this.myName = name;
        this.myDescription = description;
        this.myDefaultExtension = defaultExtension;
        this.myIcon = icon;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            QtFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            QtFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        String string = this.myDefaultExtension;
        if (string == null) {
            QtFileType.$$$reportNull$$$0(2);
        }
        return string;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content2) {
        if (file == null) {
            QtFileType.$$$reportNull$$$0(3);
        }
        if (content2 == null) {
            QtFileType.$$$reportNull$$$0(4);
        }
        return null;
    }

    public boolean openFileInAssociatedApplication(Project project, @NotNull VirtualFile file) {
        String qtTool;
        if (file == null) {
            QtFileType.$$$reportNull$$$0(5);
        }
        if ((qtTool = QtFileType.findQtTool(ModuleUtil.findModuleForFile((VirtualFile)file, (Project)project), this.getToolName())) == null) {
            return false;
        }
        try {
            Runtime.getRuntime().exec(new String[]{qtTool, file.getPath()});
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)("Failed to run Qt Designer: " + e.getMessage()), (String)"Error");
        }
        return true;
    }

    public static String findQtTool(Module module2, String toolName) {
        if (SystemInfo.isWindows) {
            if (module2 == null) {
                return null;
            }
            Sdk sdk = PythonSdkType.findPythonSdk(module2);
            if (sdk == null) {
                return null;
            }
            String tool = QtFileType.findToolInPackage(toolName, module2, "PyQt4");
            if (tool != null) {
                return tool;
            }
            return QtFileType.findToolInPackage(toolName, module2, "PySide");
        }
        return null;
    }

    @Nullable
    private static String findToolInPackage(String toolName, Module module2, String name) {
        List<PsiElement> results = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromDottedString((String)name), PyResolveImportUtil.fromModule(module2));
        return StreamEx.of(results).select(PsiDirectory.class).map(directory2 -> directory2.getVirtualFile().findChild(toolName + ".exe")).nonNull().map(VirtualFile::getPath).findFirst().orElse(null);
    }

    protected abstract String getToolName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/pyqt/QtFileType";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtension";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/pyqt/QtFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openFileInAssociatedApplication";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

