/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.Map;
import org.springframework.asm.Type;
import org.springframework.core.annotation.AnnotationAttributes;

abstract class AnnotationReadingVisitorUtils {
    AnnotationReadingVisitorUtils() {
    }

    public static AnnotationAttributes convertClassValues(ClassLoader classLoader, AnnotationAttributes original, boolean classValuesAsString) {
        if (original == null) {
            return null;
        }
        AnnotationAttributes result = new AnnotationAttributes(original.size());
        for (Map.Entry entry : original.entrySet()) {
            try {
                int i;
                Object value = entry.getValue();
                if (value instanceof AnnotationAttributes) {
                    value = AnnotationReadingVisitorUtils.convertClassValues(classLoader, (AnnotationAttributes)value, classValuesAsString);
                } else if (value instanceof AnnotationAttributes[]) {
                    AnnotationAttributes[] values = (AnnotationAttributes[])value;
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        values[i2] = AnnotationReadingVisitorUtils.convertClassValues(classLoader, values[i2], classValuesAsString);
                    }
                } else if (value instanceof Type) {
                    value = classValuesAsString ? ((Type)value).getClassName() : classLoader.loadClass(((Type)value).getClassName());
                } else if (value instanceof Type[]) {
                    Type[] array = (Type[])value;
                    Object[] convArray = classValuesAsString ? new String[array.length] : new Class[array.length];
                    for (i = 0; i < array.length; ++i) {
                        convArray[i] = classValuesAsString ? array[i].getClassName() : classLoader.loadClass(array[i].getClassName());
                    }
                    value = convArray;
                } else if (classValuesAsString) {
                    if (value instanceof Class) {
                        value = ((Class)value).getName();
                    } else if (value instanceof Class[]) {
                        Class[] clazzArray = (Class[])value;
                        String[] newValue = new String[clazzArray.length];
                        for (i = 0; i < clazzArray.length; ++i) {
                            newValue[i] = clazzArray[i].getName();
                        }
                        value = newValue;
                    }
                }
                result.put(entry.getKey(), value);
            }
            catch (Exception ex) {}
        }
        return result;
    }
}

