/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import org.netbeans.api.visual.border.Border;

public final class ImageBorder
implements Border {
    private Insets borderInsets;
    private Insets imageInsets;
    private Image image;
    private int width;
    private int height;
    private int verStep;
    private int horStep;
    private int verEdge;
    private int horEdge;

    public ImageBorder(Insets borderInsets, Insets imageInsets, Image image) {
        this.borderInsets = borderInsets;
        this.imageInsets = imageInsets;
        this.image = image;
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.horEdge = this.width - this.imageInsets.right;
        this.verEdge = this.height - this.imageInsets.bottom;
        this.horStep = this.horEdge - this.imageInsets.left;
        this.verStep = this.verEdge - this.imageInsets.top;
    }

    @Override
    public Insets getInsets() {
        return this.borderInsets;
    }

    @Override
    public void paint(Graphics2D gr, Rectangle bounds) {
        int destVerMax = bounds.y + bounds.height;
        int destHorMax = bounds.x + bounds.width;
        int destVerEdge = destVerMax - this.imageInsets.bottom;
        int destHorEdge = destHorMax - this.imageInsets.right;
        int horInner = bounds.width - this.imageInsets.left - this.imageInsets.right;
        int xdiv = horInner / this.horStep;
        int xmod = horInner % this.horStep;
        gr.drawImage(this.image, bounds.x, bounds.y, bounds.x + xmod + this.imageInsets.left, bounds.y + this.imageInsets.top, 0, 0, xmod + this.imageInsets.left, this.imageInsets.top, null);
        gr.drawImage(this.image, destHorEdge - xmod, destVerEdge, destHorMax, destVerMax, this.horEdge - xmod, this.verEdge, this.width, this.height, null);
        int i = 0;
        int x = bounds.x + xmod + this.imageInsets.left;
        while (i < xdiv) {
            gr.drawImage(this.image, x, bounds.y, x + this.horStep, bounds.y + this.imageInsets.top, this.imageInsets.left, 0, this.horEdge, this.imageInsets.top, null);
            gr.drawImage(this.image, x - xmod, destVerEdge, x - xmod + this.horStep, destVerMax, this.imageInsets.left, this.verEdge, this.horEdge, this.height, null);
            ++i;
            x += this.horStep;
        }
        int verInner = bounds.height - this.imageInsets.top - this.imageInsets.bottom;
        int ydiv = verInner / this.verStep;
        int ymod = verInner % this.verStep;
        gr.drawImage(this.image, destHorEdge, bounds.y, destHorMax, bounds.y + ymod + this.imageInsets.top, this.horEdge, 0, this.width, ymod + this.imageInsets.top, null);
        gr.drawImage(this.image, bounds.x, destVerEdge - ymod, bounds.x + this.imageInsets.left, destVerMax, 0, this.verEdge - ymod, this.imageInsets.left, this.height, null);
        int i2 = 0;
        int y = bounds.y + ymod + this.imageInsets.top;
        while (i2 < ydiv) {
            gr.drawImage(this.image, destHorEdge, y, destHorMax, y + this.verStep, this.horEdge, this.imageInsets.top, this.width, this.verEdge, null);
            gr.drawImage(this.image, bounds.x, y - ymod, bounds.x + this.imageInsets.left, y - ymod + this.verStep, 0, this.imageInsets.top, this.imageInsets.left, this.verEdge, null);
            ++i2;
            y += this.verStep;
        }
    }

    @Override
    public boolean isOpaque() {
        return false;
    }
}

