/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.task;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;

public class IISConfig {
    public static final String WORKERS_CONFIG = "/conf/workers.properties";
    public static final String URL_WORKERS_MAP_CONFIG = "/conf/uriworkermap.properties";
    public static final String JK_LOG_LOCATION = "/logs/iis_redirect.log";
    public static final String IIS_REG_FILE = "/conf/iis_redirect.reg";

    public void execute(ContextManager cm) throws TomcatException {
        try {
            String tomcatHome = cm.getHome();
            PrintWriter regfile = new PrintWriter(new FileWriter(tomcatHome + IIS_REG_FILE + "-auto"));
            PrintWriter uri_worker = new PrintWriter(new FileWriter(tomcatHome + URL_WORKERS_MAP_CONFIG + "-auto"));
            regfile.println("REGEDIT4");
            regfile.println();
            regfile.println("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Apache Software Foundation\\Jakarta Isapi Redirector\\1.0]");
            regfile.println("\"extension_uri\"=\"/jakarta/isapi_redirect.dll\"");
            regfile.println("\"log_file\"=\"" + this.dubleSlash(new File(tomcatHome, JK_LOG_LOCATION).toString()) + "\"");
            regfile.println("\"log_level\"=\"debug\"");
            regfile.println("\"worker_file\"=\"" + this.dubleSlash(new File(tomcatHome, WORKERS_CONFIG).toString()) + "\"");
            regfile.println("\"worker_mount_file\"=\"" + this.dubleSlash(new File(tomcatHome, URL_WORKERS_MAP_CONFIG).toString()) + "\"");
            uri_worker.println("###################################################################");
            uri_worker.println("# Auto generated configuration. Dated: " + new Date());
            uri_worker.println("###################################################################");
            uri_worker.println();
            uri_worker.println("#");
            uri_worker.println("# Default worker to be used through our mappings");
            uri_worker.println("#");
            uri_worker.println("default.worker=ajp12");
            uri_worker.println();
            uri_worker.println("#");
            uri_worker.println("# Root context mounts for Tomcat");
            uri_worker.println("#");
            uri_worker.println("/servlet/*=$(default.worker)");
            uri_worker.println("/*.jsp=$(default.worker)");
            uri_worker.println();
            Enumeration enumeration = cm.getContexts();
            while (enumeration.hasMoreElements()) {
                Context context = (Context)enumeration.nextElement();
                String path = context.getPath();
                String vhost = context.getHost();
                if (vhost != null || path.length() <= 1) continue;
                uri_worker.println("#########################################################");
                uri_worker.println("# Auto configuration for the " + path + " context starts.");
                uri_worker.println("#########################################################");
                uri_worker.println();
                uri_worker.println("#");
                uri_worker.println("# The following line mounts all JSP file and the /servlet/ uri to tomcat");
                uri_worker.println("#");
                uri_worker.println(path + "/servlet/*=$(default.worker)");
                uri_worker.println(path + "/*.jsp=$(default.worker)");
                uri_worker.println();
                uri_worker.println("#");
                uri_worker.println("# If you want tomcat to serve all the resources (including static) that");
                uri_worker.println("# are part of the " + path + " context, uncomment the following line");
                uri_worker.println("#");
                uri_worker.println("# " + path + "/*=$(default.worker)");
                uri_worker.println("#######################################################");
                uri_worker.println("# Auto configuration for the " + path + " context ends.");
                uri_worker.println("#######################################################");
                uri_worker.println();
            }
            regfile.close();
            uri_worker.close();
        }
        catch (Exception ex) {
            System.out.println("Error generating automatic IIS configuration " + ex);
            ex.printStackTrace(System.out);
        }
    }

    protected String dubleSlash(String in) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            char ch = in.charAt(i);
            if ('\\' == ch) {
                sb.append("\\\\");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }
}

