/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.netbeans.modules.print.util.Macro;
import org.netbeans.modules.print.util.UI;
import org.openide.util.NbPreferences;

public final class Config {
    private PageFormat myPageFormat;
    private static final Config DEFAULT = new Config();
    private static final double INCH = 72.0;
    private static final Font DEFAULT_TITLE_FONT = new Font("Serif", 0, 10);
    private static final Font DEFAULT_TEXT_FONT = new Font("Monospaced", 0, 10);
    private static final Color DEFAULT_BACGROUND_COLOR = new Color(255, 250, 255);
    private static final String COMMA = ",";
    private static final String EMPTY = "";
    private static final String HEADER_LEFT_TEXT = Macro.NAME.getName();
    private static final String HEADER_CENTER_TEXT = "";
    private static final String HEADER_RIGHT_TEXT = "";
    private static final String FOOTER_LEFT_TEXT = Config.getPageOfCount(Config.getRowColumn(Macro.ROW.getName(), Macro.COLUMN.getName()), Macro.COUNT.getName());
    private static final String FOOTER_CENTER_TEXT = "";
    private static final String FOOTER_RIGHT_TEXT = Macro.MODIFIED_DATE.getName() + "  " + Macro.MODIFIED_TIME.getName();
    private static final String SELECTION = "print.text.selection";
    private static final String AS_EDITOR = "print.text.as.editor";
    private static final String WRAP_LINES = "print.text.wrap.lines";
    private static final String LINE_NUMBERS = "print.text.line.numbers";
    private static final String USE_FONT = "print.text.use.font";
    private static final String USE_COLOR = "print.text.use.color";
    private static final String TEXT_COLOR = "print.text.color";
    private static final String TEXT_FONT = "print.text.font";
    private static final String LINE_SPACING = "print.text.line.spacing";
    private static final String BACKGROUND_COLOR = "print.text.background.color";
    private static final String ZOOM = "print.zoom";
    private static final String BORDER = "print.border";
    private static final String BORDER_COLOR = "print.border.color";
    private static final String HEADER = "print.header";
    private static final String HEADER_LEFT = "print.header.left";
    private static final String HEADER_CENTER = "print.header.center";
    private static final String HEADER_RIGHT = "print.header.right";
    private static final String HEADER_COLOR = "print.header.color";
    private static final String HEADER_FONT = "print.header.font";
    private static final String FOOTER = "print.footer";
    private static final String FOOTER_LEFT = "print.footer.left";
    private static final String FOOTER_CENTER = "print.footer.center";
    private static final String FOOTER_RIGHT = "print.footer.right";
    private static final String FOOTER_COLOR = "print.footer.color";
    private static final String FOOTER_FONT = "print.footer.font";
    private static final String PAGE_ORIENTATION = "print.page.orientation";
    private static final String PAPER_WIDTH = "print.paper.width";
    private static final String PAPER_HEIGHT = "print.paper.height";
    private static final String AREA_X = "print.area.x";
    private static final String AREA_Y = "print.area.y";
    private static final String AREA_WIDTH = "print.area.width";
    private static final String AREA_HEIGHT = "print.area.height";
    public static final FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);

    private Config() {
    }

    public boolean showPageSetup() {
        PageFormat newFormat;
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat oldFormat = this.getPageFormat();
        if (oldFormat == (newFormat = job.pageDialog(oldFormat))) {
            return false;
        }
        this.myPageFormat = newFormat;
        this.set(PAGE_ORIENTATION, this.myPageFormat.getOrientation());
        Paper paper = this.myPageFormat.getPaper();
        this.set(PAPER_WIDTH, paper.getWidth());
        this.set(PAPER_HEIGHT, paper.getHeight());
        this.set(AREA_X, paper.getImageableX());
        this.set(AREA_Y, paper.getImageableY());
        this.set(AREA_WIDTH, paper.getImageableWidth());
        this.set(AREA_HEIGHT, paper.getImageableHeight());
        return true;
    }

    public PageFormat getPageFormat() {
        PrinterJob job = PrinterJob.getPrinterJob();
        if (this.myPageFormat == null) {
            this.myPageFormat = job.defaultPage();
            this.myPageFormat.setOrientation(UI.round(this.get(PAGE_ORIENTATION, 1.0)));
            Paper paper = this.myPageFormat.getPaper();
            if (this.get(PAPER_WIDTH, null) != null && this.get(PAPER_HEIGHT, null) != null) {
                paper.setSize(this.get(PAPER_WIDTH, 72.0), this.get(PAPER_HEIGHT, 72.0));
            }
            if (this.get(AREA_X, null) != null && this.get(AREA_Y, null) != null && this.get(AREA_WIDTH, null) != null && this.get(AREA_HEIGHT, null) != null) {
                paper.setImageableArea(this.get(AREA_X, 72.0), this.get(AREA_Y, 72.0), this.get(AREA_WIDTH, 72.0), this.get(AREA_HEIGHT, 72.0));
            }
            this.myPageFormat.setPaper(paper);
        }
        return this.myPageFormat;
    }

    public int getPaperWidth() {
        return (int)Math.floor(this.getPageFormat().getWidth());
    }

    public int getPaperHeight() {
        return (int)Math.floor(this.getPageFormat().getHeight());
    }

    public int getPageX() {
        return UI.round(this.getPageFormat().getImageableX());
    }

    public int getPageY() {
        int y = UI.round(this.getPageFormat().getImageableY());
        if (this.hasHeader()) {
            y = (int)((double)y + this.getBound(this.getHeaderFont()).getHeight());
        }
        return y;
    }

    public int getPageWidth() {
        return (int)Math.floor(this.getPageFormat().getImageableWidth());
    }

    public int getPageHeight() {
        int height = (int)Math.floor(this.getPageFormat().getImageableHeight());
        if (this.hasHeader()) {
            height = (int)((double)height - this.getBound(this.getHeaderFont()).getHeight());
        }
        if (this.hasFooter()) {
            height = (int)((double)height - this.getBound(this.getFooterFont()).getHeight());
        }
        return height;
    }

    public int getHeaderY() {
        return this.getPageY() - UI.round(this.getBound(this.getHeaderFont()).getMaxY());
    }

    public int getFooterY() {
        return this.getPageY() + this.getPageHeight() + UI.round(this.getBound(this.getFooterFont()).getHeight() - this.getBound(this.getFooterFont()).getMaxY());
    }

    public boolean hasBorder() {
        return this.get(BORDER, true);
    }

    public void setBorder(boolean value) {
        this.set(BORDER, value);
    }

    public boolean isSelection() {
        return this.get(SELECTION, false);
    }

    public void setSelection(boolean value) {
        this.set(SELECTION, value);
    }

    public boolean isAsEditor() {
        return this.get(AS_EDITOR, false);
    }

    public void setAsEditor(boolean value) {
        this.set(AS_EDITOR, value);
    }

    public Color getBorderColor() {
        return this.getColor(this.get(BORDER_COLOR, null), Color.black);
    }

    public void setBorderColor(Color value) {
        this.set(BORDER_COLOR, this.getString(value));
    }

    public boolean hasHeader() {
        return this.get(HEADER, true);
    }

    public void setHeader(boolean value) {
        this.set(HEADER, value);
    }

    public String getHeaderLeft() {
        return this.get(HEADER_LEFT, HEADER_LEFT_TEXT);
    }

    public String getHeaderCenter() {
        return this.get(HEADER_CENTER, "");
    }

    public String getHeaderRight() {
        return this.get(HEADER_RIGHT, "");
    }

    public void setHeaderLeft(String value) {
        this.set(HEADER_LEFT, value);
    }

    public void setHeaderCenter(String value) {
        this.set(HEADER_CENTER, value);
    }

    public void setHeaderRight(String value) {
        this.set(HEADER_RIGHT, value);
    }

    public Color getHeaderColor() {
        return this.getColor(this.get(HEADER_COLOR, null), Color.black);
    }

    public Font getHeaderFont() {
        return this.getFont(this.get(HEADER_FONT, null), DEFAULT_TITLE_FONT);
    }

    public void setHeaderColor(Color value) {
        this.set(HEADER_COLOR, this.getString(value));
    }

    public void setHeaderFont(Font value) {
        this.set(HEADER_FONT, this.getString(value));
    }

    public boolean hasFooter() {
        return this.get(FOOTER, true);
    }

    public void setFooter(boolean value) {
        this.set(FOOTER, value);
    }

    public String getFooterLeft() {
        return this.get(FOOTER_LEFT, FOOTER_LEFT_TEXT);
    }

    public String getFooterCenter() {
        return this.get(FOOTER_CENTER, "");
    }

    public String getFooterRight() {
        return this.get(FOOTER_RIGHT, FOOTER_RIGHT_TEXT);
    }

    public void setFooterLeft(String value) {
        this.set(FOOTER_LEFT, value);
    }

    public void setFooterCenter(String value) {
        this.set(FOOTER_CENTER, value);
    }

    public void setFooterRight(String value) {
        this.set(FOOTER_RIGHT, value);
    }

    public Color getFooterColor() {
        return this.getColor(this.get(FOOTER_COLOR, null), Color.black);
    }

    public Font getFooterFont() {
        return this.getFont(this.get(FOOTER_FONT, null), DEFAULT_TITLE_FONT);
    }

    public void setFooterColor(Color value) {
        this.set(FOOTER_COLOR, this.getString(value));
    }

    public void setFooterFont(Font value) {
        this.set(FOOTER_FONT, this.getString(value));
    }

    public void setWrapLines(boolean value) {
        this.set(WRAP_LINES, value);
    }

    public boolean isWrapLines() {
        return this.get(WRAP_LINES, false);
    }

    public boolean isLineNumbers() {
        return this.get(LINE_NUMBERS, false);
    }

    public void setLineNumbers(boolean value) {
        this.set(LINE_NUMBERS, value);
    }

    public boolean isUseFont() {
        return this.get(USE_FONT, true);
    }

    public void setUseFont(boolean value) {
        this.set(USE_FONT, value);
    }

    public boolean isUseColor() {
        return this.get(USE_COLOR, true);
    }

    public void setUseColor(boolean value) {
        this.set(USE_COLOR, value);
    }

    public Color getTextColor() {
        return this.getColor(this.get(TEXT_COLOR, null), Color.black);
    }

    public void setTextColor(Color value) {
        this.set(TEXT_COLOR, this.getString(value));
    }

    public Font getTextFont() {
        return this.getFont(this.get(TEXT_FONT, null), DEFAULT_TEXT_FONT);
    }

    public void setTextFont(Font value) {
        this.set(TEXT_FONT, this.getString(value));
    }

    public Color getBackgroundColor() {
        return this.getColor(this.get(BACKGROUND_COLOR, null), DEFAULT_BACGROUND_COLOR);
    }

    public void setBackgroundColor(Color value) {
        this.set(BACKGROUND_COLOR, this.getString(value));
    }

    public double getLineSpacing() {
        return this.get(LINE_SPACING, 1.0);
    }

    public void setLineSpacing(double value) {
        this.set(LINE_SPACING, value);
    }

    public void setZoom(double value) {
        this.set(ZOOM, value);
    }

    public double getZoom() {
        return this.get(ZOOM, 1.0);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(Config.class);
    }

    private String get(String name, String defaultValue) {
        return this.getPreferences().get(name, defaultValue);
    }

    private boolean get(String name, boolean defaultValue) {
        return this.getPreferences().getBoolean(name, defaultValue);
    }

    private double get(String name, double defaultValue) {
        return this.getPreferences().getDouble(name, defaultValue);
    }

    private void set(String name, String value) {
        this.getPreferences().put(name, value);
    }

    private void set(String name, boolean value) {
        this.getPreferences().putBoolean(name, value);
    }

    private void set(String name, double value) {
        this.getPreferences().putDouble(name, value);
    }

    private String getString(Color value) {
        return value.getRed() + COMMA + value.getGreen() + COMMA + value.getBlue();
    }

    private String getString(Font value) {
        return value.getName() + COMMA + value.getStyle() + COMMA + value.getSize();
    }

    private Color getColor(String value, Color defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        StringTokenizer stk = new StringTokenizer(value, COMMA);
        int red = this.integer(stk);
        int green = this.integer(stk);
        int blue = this.integer(stk);
        if (red == -1 || green == -1 || blue == -1) {
            return defaultValue;
        }
        return new Color(red, green, blue);
    }

    private Font getFont(String value, Font defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        StringTokenizer stk = new StringTokenizer(value, COMMA);
        String name = this.getString(stk);
        int style = this.integer(stk);
        int size = this.integer(stk);
        if (name == null || style == -1 || size == -1) {
            return defaultValue;
        }
        return new Font(name, style, size);
    }

    private int integer(StringTokenizer stk) {
        if (!stk.hasMoreTokens()) {
            return -1;
        }
        return UI.getInt(stk.nextToken());
    }

    private String getString(StringTokenizer stk) {
        if (!stk.hasMoreTokens()) {
            return null;
        }
        return stk.nextToken();
    }

    private Rectangle2D getBound(Font font) {
        return font.getMaxCharBounds(FONT_RENDER_CONTEXT);
    }

    public static String getPageOfCount(String page, String count) {
        return UI.i18n(Config.class, "LBL_Page_of_Count", page, count);
    }

    private static String getRowColumn(String row, String column) {
        return UI.i18n(Config.class, "LBL_Row_Column", row, column);
    }

    public static Config getDefault() {
        return DEFAULT;
    }

    public Graphics2D getGraphics(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        return graphics;
    }
}

