/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.provider;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.print.provider.ComponentDocument;
import org.netbeans.modules.print.provider.ComponentPanel;
import org.netbeans.modules.print.provider.ComponentProvider;
import org.netbeans.modules.print.util.Config;
import org.openide.cookies.EditorCookie;
import org.openide.util.Lookup;

public final class EditorProvider
extends ComponentProvider {
    private EditorCookie myEditor;

    public EditorProvider(EditorCookie editor, Date lastModified) {
        super(null, EditorProvider.getName(editor), lastModified);
        this.myEditor = editor;
    }

    @Override
    protected JComponent getComponent() {
        int end;
        int start;
        JTextComponent text = this.getTextComponent();
        if (text == null) {
            return null;
        }
        if (Config.getDefault().isAsEditor()) {
            return this.getEditorComponent(text);
        }
        StyledDocument document = this.myEditor.getDocument();
        if (document == null) {
            return null;
        }
        if (Config.getDefault().isSelection()) {
            start = text.getSelectionStart();
            end = text.getSelectionEnd();
        } else {
            start = 0;
            end = document.getLength();
        }
        AttributedCharacterIterator[] iterators = this.getIterators(document, start, end);
        if (iterators != null) {
            return new ComponentDocument(iterators);
        }
        try {
            return new ComponentDocument(text.getText(start, end - start));
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private AttributedCharacterIterator[] getIterators(Document document, int start, int end) {
        ActionListener action = (ActionListener)Lookup.getDefault().lookup(ActionListener.class);
        if (action == null) {
            return null;
        }
        if (!action.getClass().getName().contains(".print.")) {
            return null;
        }
        ArrayList<Object> source = new ArrayList<Object>();
        source.add(document);
        source.add(start);
        source.add(end);
        ActionEvent event = new ActionEvent(source, 0, null);
        action.actionPerformed(event);
        Object object = event.getSource();
        if (!(object instanceof List)) {
            return null;
        }
        List list = (List)object;
        if (list.size() != 4) {
            return null;
        }
        Object param = list.get(3);
        if (!(param instanceof AttributedCharacterIterator[])) {
            return null;
        }
        return (AttributedCharacterIterator[])param;
    }

    private static String getName(EditorCookie editor) {
        StyledDocument document = editor.getDocument();
        if (document == null) {
            return null;
        }
        String title = (String)document.getProperty("title");
        if (title == null) {
            return null;
        }
        return title.replace('\\', '/');
    }

    private JTextComponent getTextComponent() {
        JEditorPane[] panes = this.myEditor.getOpenedPanes();
        if (panes == null || panes.length == 0) {
            return null;
        }
        return panes[0];
    }

    private JComponent getEditorComponent(JComponent text) {
        if (!Config.getDefault().isLineNumbers()) {
            return text;
        }
        JComponent lineNumber = this.getLineNumberComponent(this.getParent(text));
        if (lineNumber == null) {
            return text;
        }
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        components.add(lineNumber);
        components.add(text);
        return new ComponentPanel(components);
    }

    private JComponent getLineNumberComponent(Component component) {
        Component[] children;
        if (component == null) {
            return null;
        }
        if (component.getClass().getName().equals("org.netbeans.editor.GlyphGutter") && component instanceof JComponent) {
            return (JComponent)component;
        }
        if (!(component instanceof Container)) {
            return null;
        }
        Container container = (Container)component;
        for (Component child : children = container.getComponents()) {
            JComponent lineNumberComponent = this.getLineNumberComponent(child);
            if (lineNumberComponent == null) continue;
            return lineNumberComponent;
        }
        return null;
    }

    private Component getParent(Component component) {
        Container parent = component.getParent();
        if (parent == null) {
            return component;
        }
        return this.getParent(parent);
    }
}

