/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.dataobject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.languages.dataobject.LanguagesDataLoader;
import org.netbeans.modules.languages.dataobject.LanguagesDataNode;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;

public class LanguagesDataObject
extends MultiDataObject {
    public LanguagesDataObject(FileObject pf, LanguagesDataLoader loader) throws DataObjectExistsException, IOException {
        super(pf, (MultiFileLoader)loader);
        CookieSet cookies = this.getCookieSet();
        cookies.add((Node.Cookie)DataEditorSupport.create((DataObject)this, (MultiDataObject.Entry)this.getPrimaryEntry(), (CookieSet)cookies));
    }

    protected Node createNodeDelegate() {
        return new LanguagesDataNode(this);
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    protected DataObject handleCreateFromTemplate(DataFolder df, String name) throws IOException {
        DataObject createdClass = super.handleCreateFromTemplate(df, name);
        FileObject createdClassFO = createdClass.getPrimaryFile();
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("__CLASS_NAME__", name);
        tokens.put("__PACKAGE_NAME__", LanguagesDataObject.getPackageName(createdClassFO));
        LanguagesDataObject.createFileWithSubstitutions(this.getPrimaryFile(), createdClassFO, tokens);
        return createdClass;
    }

    static String getPackageName(FileObject createdClass) {
        FileObject parent;
        for (parent = createdClass.getParent(); parent != null && !"src".equals(parent.getNameExt()); parent = parent.getParent()) {
        }
        return parent == null ? "test" : createdClass.getParent().getPath().substring(parent.getPath().length() + 1).replace('/', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createFileWithSubstitutions(FileObject sourceFO, FileObject targetFO, Map<String, String> tokens) throws IOException {
        FileLock lock = targetFO.lock();
        try {
            LanguagesDataObject.copyAndSubstituteTokens(sourceFO.getURL(), lock, targetFO, tokens);
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyAndSubstituteTokens(URL content, FileLock lock, FileObject targetFO, Map<String, String> tokens) throws IOException {
        OutputStream os = targetFO.getOutputStream(lock);
        try {
            PrintWriter pw = new PrintWriter(os);
            try {
                InputStream is = content.openStream();
                try {
                    String line;
                    InputStreamReader r = new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(r);
                    while ((line = br.readLine()) != null) {
                        pw.println(tokens == null ? line : LanguagesDataObject.replaceTokens(tokens, line));
                    }
                }
                finally {
                    is.close();
                }
            }
            finally {
                pw.close();
            }
        }
        finally {
            os.close();
        }
    }

    private static String replaceTokens(Map<String, String> tokens, String line) {
        for (Map.Entry<String, String> entry : tokens.entrySet()) {
            line = line.replaceAll(entry.getKey(), entry.getValue());
        }
        return line;
    }
}

