/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocket;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.net.AuthenticatedProxy;
import org.eclipse.mylyn.commons.core.operations.ICancellable;
import org.eclipse.mylyn.commons.core.operations.MonitoredOperation;
import org.eclipse.mylyn.internal.commons.core.CommonsCorePlugin;
import org.eclipse.osgi.util.NLS;

public class NetUtil {
    private static final String PROPERTY_MAX_HTTP_HOST_CONNECTIONS = "org.eclipse.mylyn.http.connections.per.host";
    private static final String PROPERTY_MAX_HTTP_TOTAL_CONNECTIONS = "org.eclipse.mylyn.http.total.connections";
    private static final int HTTPS_PORT = 443;
    private static final int HTTP_PORT = 80;
    private static final int MAX_HTTP_HOST_CONNECTIONS_DEFAULT = 100;
    private static final int MAX_HTTP_TOTAL_CONNECTIONS_DEFAULT = 1000;
    private static final String[] enabledProtocols;
    private static final AtomicBoolean loggedEnabledProtocolsException;

    static {
        loggedEnabledProtocolsException = new AtomicBoolean();
        String value = System.getProperty("org.eclipse.mylyn.https.protocols");
        enabledProtocols = value != null ? value.split(",") : null;
    }

    @Deprecated
    public static void connect(final Socket socket, InetSocketAddress address, int timeout, MonitoredOperation<?> operation) throws IOException {
        if (operation != null) {
            ICancellable listener = new ICancellable(){

                @Override
                public void abort() {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            };
            try {
                operation.addListener(listener);
                socket.connect(address, timeout);
            }
            finally {
                operation.removeListener(listener);
            }
        } else {
            socket.connect(address, timeout);
        }
    }

    public static Proxy createProxy(String proxyHost, int proxyPort) {
        return NetUtil.createProxy(proxyHost, proxyPort, null, null, null);
    }

    public static Proxy createProxy(String proxyHost, int proxyPort, String username, String password, String domain) {
        if (proxyHost != null && proxyHost.length() > 0) {
            boolean authenticated;
            InetSocketAddress sockAddr = new InetSocketAddress(proxyHost, proxyPort);
            boolean bl = authenticated = username != null && password != null && username.length() > 0 && password.length() > 0;
            if (authenticated) {
                return new AuthenticatedProxy(Proxy.Type.HTTP, sockAddr, username, password, domain);
            }
            return new Proxy(Proxy.Type.HTTP, sockAddr);
        }
        return Proxy.NO_PROXY;
    }

    public static String getHost(String url) {
        Assert.isNotNull((Object)url);
        String result = url;
        int colonSlashSlash = url.indexOf("://");
        if (colonSlashSlash >= 0) {
            result = url.substring(colonSlashSlash + 3);
        }
        int colonPort = result.indexOf(58);
        int requestPath = result.indexOf(47);
        int substringEnd = colonPort > 0 && requestPath > 0 ? Math.min(colonPort, requestPath) : (colonPort > 0 ? colonPort : (requestPath > 0 ? requestPath : result.length()));
        return result.substring(0, substringEnd);
    }

    public static int getPort(String url) {
        Assert.isNotNull((Object)url);
        int colonSlashSlash = url.indexOf("://");
        int firstSlash = url.indexOf("/", colonSlashSlash + 3);
        int colonPort = url.indexOf(58, colonSlashSlash + 1);
        if (firstSlash == -1) {
            firstSlash = url.length();
        }
        if (colonPort < 0 || colonPort > firstSlash) {
            return NetUtil.isUrlHttps(url) ? 443 : 80;
        }
        int requestPath = url.indexOf(47, colonPort + 1);
        int end = requestPath < 0 ? url.length() : requestPath;
        String port = url.substring(colonPort + 1, end);
        if (port.length() == 0) {
            return NetUtil.isUrlHttps(url) ? 443 : 80;
        }
        return Integer.parseInt(port);
    }

    public static Proxy getProxy(String host, Proxy.Type proxyType) {
        Assert.isNotNull((Object)host);
        Assert.isNotNull((Object)((Object)proxyType));
        return NetUtil.getProxy(host, NetUtil.getPlatformProxyType(proxyType));
    }

    public static Proxy getProxy(String host, String proxyType) {
        Assert.isNotNull((Object)host);
        Assert.isNotNull((Object)proxyType);
        IProxyService service = CommonsCorePlugin.getProxyService();
        if (service != null && service.isProxiesEnabled()) {
            IProxyData data = service.getProxyDataForHost(host, proxyType);
            if (data != null && data.getHost() != null) {
                String proxyHost = data.getHost();
                int proxyPort = data.getPort();
                if (proxyPort == -1) {
                    proxyPort = 0;
                }
                return NetUtil.createProxy(proxyHost, proxyPort, data.getUserId(), data.getPassword(), null);
            }
        } else {
            try {
                Proxy proxy;
                URI uri = new URI(proxyType, "//" + host, null);
                List<Proxy> proxies = ProxySelector.getDefault().select(uri);
                if (proxies != null && proxies.size() > 0 && (proxy = proxies.iterator().next()) != Proxy.NO_PROXY) {
                    return proxy;
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return null;
    }

    public static Proxy getProxyForUrl(String url) {
        String host = NetUtil.getHost(url);
        Proxy proxy = NetUtil.isUrlHttps(url) ? NetUtil.getProxy(host, "HTTPS") : NetUtil.getProxy(host, "HTTP");
        return proxy;
    }

    public static String getRequestPath(String url) {
        int colonSlashSlash = url.indexOf("://");
        int requestPath = url.indexOf(47, colonSlashSlash + 3);
        if (requestPath < 0) {
            return "";
        }
        return url.substring(requestPath);
    }

    public static boolean isUrlHttps(String url) {
        return url.matches("https.*");
    }

    private static String getPlatformProxyType(Proxy.Type type) {
        return type == Proxy.Type.SOCKS ? "SOCKS" : "HTTP";
    }

    public static Socket configureSocket(Socket socket) {
        block3: {
            if (socket instanceof SSLSocket && enabledProtocols != null) {
                try {
                    ((SSLSocket)socket).setEnabledProtocols(enabledProtocols);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (loggedEnabledProtocolsException.getAndSet(true)) break block3;
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.core", NLS.bind((String)"Failed to configure SSL protocols ''{0}''", (Object)Arrays.toString(enabledProtocols))));
                }
            }
        }
        return socket;
    }

    public static int getMaxHttpConnectionsPerHost() {
        return NetUtil.getSystemPropertyAndParseInt(PROPERTY_MAX_HTTP_HOST_CONNECTIONS, 100);
    }

    public static int getMaxHttpConnections() {
        return NetUtil.getSystemPropertyAndParseInt(PROPERTY_MAX_HTTP_TOTAL_CONNECTIONS, 1000);
    }

    private static int getSystemPropertyAndParseInt(String key, int defaultValue) {
        String property = System.getProperty(key);
        if (property != null) {
            try {
                return Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.commons.core", NLS.bind((String)"Unable to parse property {0}", (Object)key)));
            }
        }
        return defaultValue;
    }
}

