/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Vector;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Watch;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.ReorderableTreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class WatchesTreeModel
implements ReorderableTreeModel {
    private static final String PROP_SHOW_PINNED_WATCHES = "showPinnedWatches";
    private static final Properties PROPERTIES = Properties.getDefault().getProperties("debugger").getProperties("watchesProps");
    private Listener listener;
    private Vector listeners = new Vector();
    private final EmptyWatch EMPTY_WATCH = new EmptyWatch();
    static final ShowPinnedWatches showPinnedWatches = new ShowPinnedWatches();

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            Object[] ws;
            Watch[] wsTemp = DebuggerManager.getDebuggerManager().getWatches();
            if (showPinnedWatches.isShowPinnedWatches()) {
                ws = new Object[wsTemp.length + 1];
                System.arraycopy(wsTemp, 0, ws, 0, wsTemp.length);
            } else {
                int numwatches = 0;
                for (Watch w : wsTemp) {
                    if (w.getPin() != null) continue;
                    ++numwatches;
                }
                ws = new Object[numwatches + 1];
                numwatches = 0;
                for (Watch w : wsTemp) {
                    if (w.getPin() != null) continue;
                    ws[numwatches++] = w;
                }
            }
            ws[ws.length - 1] = this.EMPTY_WATCH;
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            to = Math.min(ws.length, to);
            if ((from = Math.min(ws.length, from)) > 0 || to < ws.length) {
                Object[] fws = new Object[to - from];
                System.arraycopy(ws, from, fws, 0, to - from);
                return fws;
            }
            return ws;
        }
        throw new UnknownTypeException(parent);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(node);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Watch) {
            return true;
        }
        if (node instanceof EmptyWatch) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public boolean canReorder(Object parent) throws UnknownTypeException {
        return parent == "Root";
    }

    public void reorder(Object parent, int[] perm) throws UnknownTypeException {
        if (parent != "Root") {
            throw new UnknownTypeException(parent);
        }
        int numWatches = DebuggerManager.getDebuggerManager().getWatches().length;
        perm = WatchesTreeModel.resizePermutation(perm, numWatches);
        DebuggerManager.getDebuggerManager().reorderWatches(perm);
    }

    private static int[] resizePermutation(int[] perm, int size) {
        if (size == perm.length) {
            return perm;
        }
        int[] nperm = new int[size];
        if (size < perm.length) {
            int j = 0;
            for (int i = 0; i < perm.length; ++i) {
                int p = perm[i];
                if (p >= size) continue;
                nperm[j++] = p;
            }
        } else {
            System.arraycopy(perm, 0, nperm, 0, perm.length);
            for (int i = perm.length; i < size; ++i) {
                nperm[i] = i;
            }
        }
        return nperm;
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8));
        }
    }

    void fireWatchPropertyChanged(Watch b, String propertyName) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)b));
        }
    }

    class EmptyWatch {
        EmptyWatch() {
        }

        public void setExpression(String expr) {
            String infoStr = NbBundle.getBundle(WatchesTreeModel.class).getString("CTL_WatchesModel_Empty_Watch_Hint");
            infoStr = "<" + infoStr + ">";
            if (expr == null || expr.trim().length() == 0 || infoStr.equals(expr)) {
                return;
            }
            Vector v = (Vector)WatchesTreeModel.this.listeners.clone();
            int k = v.size();
            for (int i = 0; i < k; ++i) {
                ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)WatchesTreeModel.this, (Object)this));
            }
            DebuggerManager.getDebuggerManager().createWatch(expr);
        }
    }

    static class ShowPinnedWatches {
        ShowPinnedWatches() {
        }

        boolean isShowPinnedWatches() {
            return PROPERTIES.getBoolean(WatchesTreeModel.PROP_SHOW_PINNED_WATCHES, false);
        }

        boolean isShowPinnedWatchesEnabled() {
            return true;
        }

        void setShowPinnedWatches(boolean showPinnedWatches) {
            PROPERTIES.setBoolean(WatchesTreeModel.PROP_SHOW_PINNED_WATCHES, showPinnedWatches);
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference model;

        public Listener(WatchesTreeModel tm) {
            this.model = new WeakReference<WatchesTreeModel>(tm);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            int k = ws.length;
            for (int i = 0; i < k; ++i) {
                ws[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
            PROPERTIES.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private WatchesTreeModel getModel() {
            WatchesTreeModel m = (WatchesTreeModel)this.model.get();
            if (m == null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
                Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
                int k = ws.length;
                for (int i = 0; i < k; ++i) {
                    ws[i].removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
            return m;
        }

        public void watchAdded(Watch watch) {
            WatchesTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            m.fireTreeChanged();
        }

        public void watchRemoved(Watch watch) {
            WatchesTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            m.fireTreeChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            WatchesTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            Object source = evt.getSource();
            if (source == PROPERTIES && WatchesTreeModel.PROP_SHOW_PINNED_WATCHES.equals(evt.getPropertyName())) {
                m.fireTreeChanged();
                return;
            }
            if (!(source instanceof Watch)) {
                return;
            }
            Watch w = (Watch)evt.getSource();
            m.fireWatchPropertyChanged(w, evt.getPropertyName());
        }
    }
}

