/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.beans.model.SpringConfigFileModelController;
import org.netbeans.modules.spring.beans.model.impl.ConfigFileSpringBeanSource;
import org.netbeans.modules.spring.util.fcs.FileChangeSupport;
import org.netbeans.modules.spring.util.fcs.FileChangeSupportEvent;
import org.netbeans.modules.spring.util.fcs.FileChangeSupportListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SpringConfigFileModelManager {
    private final Map<File, SpringConfigFileModelController> file2Controller = Collections.synchronizedMap(new HashMap());
    private FileListener fileListener;
    private EditorRegistryListener editorListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringConfigFileModelController getFileModelController(File file) {
        Object object = this;
        synchronized (object) {
            if (this.fileListener == null) {
                this.fileListener = new FileListener();
                this.editorListener = new EditorRegistryListener();
                this.editorListener.initialize();
            }
        }
        object = this.file2Controller;
        synchronized (object) {
            SpringConfigFileModelController controller = this.file2Controller.get(file);
            if (controller == null) {
                controller = new SpringConfigFileModelController(file, new ConfigFileSpringBeanSource());
                FileChangeSupport.DEFAULT.addListener(this.fileListener, file);
                this.file2Controller.put(file, controller);
            }
            return controller;
        }
    }

    private void notifyFileChanged(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return;
        }
        this.notifyFileChanged(fo, file);
    }

    private void notifyFileDeleted(File file) {
    }

    private void notifyFileChanged(FileObject fo, File file) {
        SpringConfigFileModelController fileController = this.file2Controller.get(file);
        if (fileController != null) {
            fileController.notifyChange(fo);
        }
    }

    private final class EditorRegistryListener
    implements PropertyChangeListener,
    DocumentListener {
        private Document currentDocument;

        public synchronized void initialize() {
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
            JTextComponent newComponent = EditorRegistry.lastFocusedComponent();
            Document document = this.currentDocument = newComponent != null ? newComponent.getDocument() : null;
            if (this.currentDocument != null) {
                this.currentDocument.addDocumentListener(this);
            }
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            Document newDocument;
            assert (SwingUtilities.isEventDispatchThread());
            JTextComponent newComponent = EditorRegistry.lastFocusedComponent();
            Document document = newDocument = newComponent != null ? newComponent.getDocument() : null;
            if (this.currentDocument == newDocument) {
                return;
            }
            if (this.currentDocument != null) {
                this.currentDocument.removeDocumentListener(this);
            }
            this.currentDocument = newDocument;
            if (this.currentDocument != null) {
                this.currentDocument.addDocumentListener(this);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.notify(e.getDocument());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.notify(e.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.notify(e.getDocument());
        }

        private void notify(Document document) {
            FileObject fo = NbEditorUtilities.getFileObject((Document)document);
            if (fo == null) {
                return;
            }
            if (!"text/x-springconfig+xml".equals(fo.getMIMEType())) {
                return;
            }
            File file = FileUtil.toFile((FileObject)fo);
            if (file == null) {
                return;
            }
            SpringConfigFileModelManager.this.notifyFileChanged(fo, file);
        }
    }

    private final class FileListener
    implements FileChangeSupportListener {
        private FileListener() {
        }

        @Override
        public void fileCreated(FileChangeSupportEvent event) {
            SpringConfigFileModelManager.this.notifyFileChanged(event.getPath());
        }

        @Override
        public void fileModified(FileChangeSupportEvent event) {
            SpringConfigFileModelManager.this.notifyFileChanged(event.getPath());
        }

        @Override
        public void fileDeleted(FileChangeSupportEvent event) {
            SpringConfigFileModelManager.this.notifyFileDeleted(event.getPath());
        }
    }
}

