/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.lang.model.element.Modifier;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.java.hints.introduce.Bundle;
import org.netbeans.modules.java.hints.introduce.MemberSearchResult;
import org.netbeans.modules.java.hints.introduce.MemberValidator;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class NameChangeSupport
extends FocusAdapter
implements DocumentListener,
Runnable {
    private static final RequestProcessor CHANGE_RP = new RequestProcessor(NameChangeSupport.class);
    private final JTextField control;
    private MemberValidator validator;
    private RequestProcessor.Task validateTask = CHANGE_RP.create((Runnable)this, true);
    private ChangeListener listener;
    private TreePathHandle target;
    private Modifier minAccess;
    private boolean valid;
    private String validateName;

    public NameChangeSupport(JTextField control) {
        this.control = control;
        control.getDocument().addDocumentListener(this);
        control.addFocusListener(this);
    }

    public synchronized void setChangeListener(ChangeListener l) {
        assert (this.listener == null);
        this.listener = l;
    }

    public synchronized void setValidator(MemberValidator val) {
        this.validator = val;
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.validateTask.cancel()) {
            this.validateName = this.control.getText().trim();
            this.run();
        }
    }

    public void setTarget(TreePathHandle target) {
        this.validateName = this.control.getText().trim();
        this.target = target;
        this.validateTask.run();
    }

    public synchronized Modifier getMinAccess() {
        return this.minAccess;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateName = this.control.getText().trim();
        this.validateTask.schedule(200);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public boolean isValid() {
        return this.validator == null ? true : this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ChangeListener l;
        MemberValidator v;
        TreePathHandle t;
        NameChangeSupport nameChangeSupport = this;
        synchronized (nameChangeSupport) {
            if (this.validateName == null) {
                return;
            }
            if (this.validator == null) {
                return;
            }
            t = this.target;
            v = this.validator;
        }
        boolean nv = false;
        Modifier mod = null;
        if (this.validateName.isEmpty()) {
            this.notifyNameError(Bundle.ERR_NameIsEmpty());
            nv = false;
        } else if (!Utilities.isJavaIdentifier((String)this.validateName)) {
            this.notifyNameError(Bundle.ERR_NameIsNotValid());
            nv = false;
        } else {
            MemberSearchResult res = v.validateName(t, this.control.getText().trim());
            nv = this.updateUI(res);
            mod = res == null ? null : res.getRequiredModifier();
        }
        NameChangeSupport nameChangeSupport2 = this;
        synchronized (nameChangeSupport2) {
            if (this.minAccess == mod && nv == this.valid) {
                return;
            }
            this.valid = nv;
            if (nv) {
                this.minAccess = mod;
            }
            l = this.listener;
        }
        if (l != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    l.stateChanged(new ChangeEvent(this));
                }
            });
        }
    }

    protected boolean updateUI(MemberSearchResult result) {
        return true;
    }

    protected void notifyNameError(String msg) {
    }
}

