/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.map;

import edu.berkeley.nlp.lm.ConfigOptions;
import edu.berkeley.nlp.lm.array.CustomWidthArray;
import edu.berkeley.nlp.lm.array.LongArray;
import edu.berkeley.nlp.lm.bits.BitList;
import edu.berkeley.nlp.lm.bits.BitStream;
import edu.berkeley.nlp.lm.bits.VariableLengthBitCompressor;
import edu.berkeley.nlp.lm.map.AbstractNgramMap;
import edu.berkeley.nlp.lm.map.CompressedMap;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.util.Annotations;
import edu.berkeley.nlp.lm.util.Logger;
import edu.berkeley.nlp.lm.values.CompressibleValueContainer;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class CompressedNgramMap<T>
extends AbstractNgramMap<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int compressedBlockSize;
    private static final int OFFSET_RADIX = 33;
    private static final int WORD_RADIX = 2;
    private final VariableLengthBitCompressor offsetCoder = new VariableLengthBitCompressor(33);
    private final VariableLengthBitCompressor wordCoder = new VariableLengthBitCompressor(2);
    private final VariableLengthBitCompressor suffixCoder;
    private double totalKeyBitsFinal = 0.0;
    private double totalValueBitsFinal = 0.0;
    private double totalBitsFinal = 0.0;
    private double totalSizeFinal = 0.0;
    private final int offsetDeltaRadix;
    private final CompressedMap[] maps;
    private final boolean reverseTrie = true;
    private final long[] numNgramsForEachOrder;

    public CompressedNgramMap(CompressibleValueContainer<T> values, long[] numNgramsForEachOrder, ConfigOptions opts) {
        super(values, opts);
        this.offsetDeltaRadix = opts.offsetDeltaRadix;
        this.suffixCoder = new VariableLengthBitCompressor(this.offsetDeltaRadix);
        this.compressedBlockSize = opts.compressedBlockSize;
        this.numNgramsForEachOrder = numNgramsForEachOrder;
        this.maps = new CompressedMap[numNgramsForEachOrder.length];
        values.setMap(this);
    }

    @Override
    public long getValueAndOffset(long contextOffset, int contextNgramOrder, int word, @Annotations.OutputParameter T outputVal) {
        if (word < 0) {
            return -1L;
        }
        long hash = this.combineToKey(word, contextOffset);
        int ngramOrder = contextNgramOrder + 1;
        LongArray compressedKeys = this.maps[ngramOrder].compressedKeys;
        long currIndex = this.decompressSearch(compressedKeys, hash, ngramOrder, outputVal);
        return currIndex;
    }

    @Override
    public long put(int[] ngram, int startPos, int endPos, T val) {
        int ngramOrder = endPos - startPos - 1;
        int word = ngram[startPos];
        long contextOffset = this.getContextOffset(ngram, startPos + 1, endPos, null);
        if (contextOffset < 0L) {
            return -1L;
        }
        CompressedMap map = this.maps[ngramOrder];
        if (map == null) {
            map = this.maps[ngramOrder] = new CompressedMap();
            long l = this.numNgramsForEachOrder[ngramOrder];
            this.maps[ngramOrder].init(l);
            this.values.setSizeAtLeast(l, ngramOrder);
        }
        long oldSize = map.size();
        long newOffset = map.add(this.combineToKey(word, contextOffset));
        boolean addWorked = this.values.add(ngram, startPos, endPos, ngramOrder, map.size() - 1L, contextOffset, word, val, -1L, map.size() == oldSize);
        if (!addWorked) {
            return -1L;
        }
        return newOffset;
    }

    private long getContextOffset(int[] ngram, int startPos, int endPos, T val) {
        if (endPos == startPos) {
            return 0L;
        }
        long hasValueSuffixIndex = 0L;
        if (endPos > startPos) {
            long lastSuffix = 0L;
            for (int ngramOrder = 0; ngramOrder < endPos - startPos; ++ngramOrder) {
                int firstWord = ngram[endPos - ngramOrder - 1];
                long key = this.combineToKey(firstWord, lastSuffix);
                if (this.maps[ngramOrder] == null) {
                    return -1L;
                }
                LongArray compressedKeys = this.maps[ngramOrder].compressedKeys;
                long currIndex = this.decompressSearch(compressedKeys, key, ngramOrder, val);
                if (currIndex < 0L) {
                    return -1L;
                }
                lastSuffix = currIndex;
            }
            hasValueSuffixIndex = lastSuffix;
        }
        return hasValueSuffixIndex;
    }

    @Override
    public void handleNgramsFinished(int justFinishedOrder) {
        CompressedMap compressedMap = this.maps[justFinishedOrder - 1];
        if (compressedMap != null) {
            LongArray currKeys = compressedMap.getUncompressedKeys();
            long currSize = currKeys.size();
            this.sort(currKeys, 0L, currSize - 1L, justFinishedOrder - 1);
            compressedMap.trim();
            this.values.trimAfterNgram(justFinishedOrder - 1, currSize);
            this.compress(justFinishedOrder - 1);
        }
    }

    protected static int compareLongsRaw(long a, long b) {
        assert (a >= 0L);
        assert (b >= 0L);
        if (a > b) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        if (a == b) {
            return 0;
        }
        throw new RuntimeException();
    }

    private void compress(int ngramOrder) {
        if (ngramOrder > 0) {
            this.maps[ngramOrder].compressedKeys = this.compress(this.maps[ngramOrder].getUncompressedKeys(), this.maps[ngramOrder].size(), ngramOrder);
            ((CompressibleValueContainer)this.values).clearStorageAfterCompression(ngramOrder);
            this.maps[ngramOrder].clearUncompressedKeys();
        }
    }

    private LongArray compress(LongArray uncompressed, long uncompressedSize, int ngramOrder) {
        Logger.startTrack("Compressing", new Object[0]);
        LongArray compressedLongArray = LongArray.StaticMethods.newLongArray(Long.MAX_VALUE, uncompressedSize >>> 2);
        long uncompressedPos = 0L;
        long totalNumKeyBits = 0L;
        long totalNumValueBits = 0L;
        long currBlock = 0L;
        CompressibleValueContainer compressibleValues = (CompressibleValueContainer)this.values;
        while (uncompressedPos < uncompressedSize) {
            BitList currBlockBits = new BitList();
            long firstKey = uncompressed.get(uncompressedPos);
            if (currBlock++ % 1000L == 0L) {
                Logger.logs("On block " + currBlock + " starting at pos " + uncompressedPos);
            }
            currBlockBits.addLong(firstKey);
            BitList offsetBits = this.offsetCoder.compress(uncompressedPos);
            BitList firstValueBits = compressibleValues.getCompressed(uncompressedPos, ngramOrder);
            BitList headerBits = new BitList();
            BitList bodyBits = new BitList();
            long numKeyBits = 0L;
            long numValueBits = 0L;
            long currUncompressedPos = -1L;
            boolean wordBitOn = false;
            boolean done = false;
            while (!done) {
                block11: {
                    numKeyBits = 0L;
                    numValueBits = 0L;
                    long lastFirstWord = this.wordOf(firstKey);
                    long lastSuffixPart = this.contextOffsetOf(firstKey);
                    headerBits = this.makeHeader(offsetBits, firstValueBits, wordBitOn);
                    bodyBits = new BitList();
                    BitList currBits = new BitList();
                    for (currUncompressedPos = uncompressedPos + 1L; currUncompressedPos < uncompressedSize; ++currUncompressedPos) {
                        long currKey = uncompressed.get(currUncompressedPos);
                        long currFirstWord = this.wordOf(currKey);
                        long currSuffixPart = this.contextOffsetOf(currKey);
                        long wordDelta = currFirstWord - lastFirstWord;
                        long suffixDelta = currSuffixPart - lastSuffixPart;
                        currBits.clear();
                        if (wordDelta <= 0L || wordBitOn) {
                            if (wordBitOn) {
                                BitList suffixBits;
                                BitList keyBits = this.wordCoder.compress(wordDelta);
                                currBits.addAll(keyBits);
                                if (wordDelta > 0L) {
                                    suffixBits = this.suffixCoder.compress(currSuffixPart);
                                    currBits.addAll(suffixBits);
                                } else {
                                    suffixBits = this.suffixCoder.compress(suffixDelta);
                                    currBits.addAll(suffixBits);
                                }
                            } else {
                                BitList suffixBits = this.suffixCoder.compress(suffixDelta);
                                currBits.addAll(suffixBits);
                            }
                            numKeyBits += (long)currBits.size();
                            lastFirstWord = currFirstWord;
                            numValueBits += this.compressValue(ngramOrder, currUncompressedPos, currBits);
                            lastSuffixPart = currSuffixPart;
                            if (this.blockFull(currBlockBits, bodyBits, headerBits, currBits)) break;
                            bodyBits.addAll(currBits);
                            continue;
                        }
                        break block11;
                    }
                    done = true;
                }
                wordBitOn = true;
            }
            uncompressedPos = currUncompressedPos;
            totalNumKeyBits += numKeyBits;
            totalNumValueBits += numValueBits;
            int bitLength = bodyBits.size() + headerBits.size();
            assert (bitLength <= Short.MAX_VALUE);
            currBlockBits.addShort((short)bitLength);
            currBlockBits.addAll(headerBits);
            currBlockBits.addAll(bodyBits);
            assert (currBlockBits.size() < 64 * this.compressedBlockSize);
            this.writeBlockToArray(currBlockBits, compressedLongArray);
        }
        compressedLongArray.trim();
        this.logCompressionInfo(uncompressedSize, compressedLongArray, totalNumKeyBits, totalNumValueBits);
        Logger.endTrack();
        return compressedLongArray;
    }

    private void writeBlockToArray(BitList blockBits, LongArray array) {
        long curr = 0L;
        for (int i = 0; i <= 64 * this.compressedBlockSize; ++i) {
            if (i % 64 == 0 && i > 0) {
                array.add(curr);
                curr = 0L;
            }
            curr = curr << 1 | (long)(i >= blockBits.size() || !blockBits.get(i) ? 0 : 1);
        }
        assert (array.size() % (long)this.compressedBlockSize == 0L);
    }

    private void logCompressionInfo(long uncompressedSize, LongArray compressedLongArray, long keyBits, long valueBits) {
        double keyAvg = (double)keyBits / (double)uncompressedSize;
        Logger.logss("Key bits " + keyAvg);
        double valueAvg = (double)valueBits / (double)uncompressedSize;
        Logger.logss("Value bits " + valueAvg);
        double avg = 64.0 * (double)compressedLongArray.size() / (double)uncompressedSize;
        Logger.logss("Compressed bits " + avg);
        this.totalKeyBitsFinal += (double)keyBits;
        this.totalValueBitsFinal += (double)valueBits;
        this.totalBitsFinal += (double)compressedLongArray.size();
        this.totalSizeFinal += (double)uncompressedSize;
        Logger.logss("Total key bits " + this.totalKeyBitsFinal / this.totalSizeFinal);
        Logger.logss("Total value bits " + this.totalValueBitsFinal / this.totalSizeFinal);
        Logger.logss("Total bits " + 64.0 * this.totalBitsFinal / this.totalSizeFinal);
    }

    private boolean blockFull(BitList currBits, BitList restBits, BitList headerBits, BitList newBits) {
        int numTotalBitsSize = 16;
        int lengthSoFar = currBits.size() + 16 + headerBits.size() + restBits.size() + newBits.size();
        return lengthSoFar >= 64 * this.compressedBlockSize;
    }

    private long compressValue(int ngramOrder, long currPos, BitList newBits) {
        BitList valueBits = ((CompressibleValueContainer)this.values).getCompressed(currPos, ngramOrder);
        newBits.addAll(valueBits);
        return valueBits.size();
    }

    private BitList makeHeader(BitList offsetBits, BitList firstValueBits, boolean wordBitOn) {
        BitList headerBits = new BitList();
        headerBits.addAll(offsetBits);
        headerBits.add(wordBitOn);
        headerBits.addAll(firstValueBits);
        return headerBits;
    }

    private long decompressLinearSearch(LongArray compressed, long pos, long searchKey, int ngramOrder, T outputVal, long searchOffset) {
        long firstKey = compressed.get(pos);
        BitStream bits = this.getCompressedBits(compressed, pos + 1L);
        long offset = this.offsetCoder.decompress(bits);
        boolean wordBitOn = bits.nextBit();
        int currWord = this.wordOf(firstKey);
        long currSuffix = this.contextOffsetOf(firstKey);
        boolean foundKeyFirst = searchOffset >= 0L ? searchOffset == offset : firstKey == searchKey;
        CompressibleValueContainer compressibleValues = (CompressibleValueContainer)this.values;
        compressibleValues.decompress(bits, ngramOrder, !foundKeyFirst, outputVal);
        if (foundKeyFirst) {
            return searchOffset >= 0L ? firstKey : offset;
        }
        long currKey = -1L;
        int k = 1;
        while (!bits.finished()) {
            int newWord = -1;
            long nextSuffix = -1L;
            if (wordBitOn) {
                int wordDelta = (int)this.wordCoder.decompress(bits);
                boolean wordDeltaIsZero = wordDelta == 0;
                long suffixDelta = this.suffixCoder.decompress(bits);
                newWord = currWord + wordDelta;
                nextSuffix = wordDeltaIsZero ? currSuffix + suffixDelta : suffixDelta;
            } else {
                long suffixDelta = this.suffixCoder.decompress(bits);
                newWord = currWord;
                nextSuffix = currSuffix + suffixDelta;
            }
            currKey = this.combineToKey(newWord, nextSuffix);
            currWord = newWord;
            currSuffix = nextSuffix;
            long currOffset = offset + (long)k;
            boolean foundKey = searchOffset >= 0L ? searchOffset == currOffset : currKey == searchKey;
            compressibleValues.decompress(bits, ngramOrder, !foundKey, outputVal);
            if (foundKey) {
                return searchOffset >= 0L ? currKey : currOffset;
            }
            if (searchOffset >= 0L ? currOffset > searchOffset : currKey > searchKey) {
                return -1L;
            }
            ++k;
        }
        return -1L;
    }

    private BitStream getCompressedBits(LongArray compressed, long pos) {
        short bitLength = this.readShort(compressed.get(pos));
        BitStream bits = new BitStream(compressed, pos, 16, bitLength);
        return bits;
    }

    private short readShort(long l) {
        return (short)(l >>> 48);
    }

    private long decompressSearch(LongArray compressed, long searchKey, int ngramOrder, T outputVal) {
        return this.decompressSearch(compressed, searchKey, ngramOrder, outputVal, -1L);
    }

    private long decompressSearch(LongArray compressed, long searchKey, int ngramOrder, T outputVal, long searchOffset) {
        if (ngramOrder == 0) {
            int word;
            boolean lookingForOffset = searchKey >= 0L;
            int n = word = lookingForOffset ? this.wordOf(searchKey) : (int)searchOffset;
            if (word < 0 || (long)word >= this.maps[0].size()) {
                return -1L;
            }
            if (outputVal != null) {
                this.values.getFromOffset(word, 0, outputVal);
            }
            return lookingForOffset ? (long)word : this.combineToKey(word, 0L);
        }
        if (compressed == null) {
            return -1L;
        }
        long fromIndex = 0L;
        long toIndex = compressed.size() / (long)this.compressedBlockSize - 1L;
        long low = this.binarySearchBlocks(compressed, compressed.size(), searchKey, 0L, toIndex, searchOffset);
        if (low < 0L) {
            return -1L;
        }
        long index = this.decompressLinearSearch(compressed, low, searchKey, ngramOrder, outputVal, searchOffset);
        return index;
    }

    private long binarySearchBlocks(LongArray compressed, long size, long searchKey, long low_, long high_, long searchOffset) {
        long toFind = searchOffset >= 0L ? searchOffset : searchKey;
        long low = low_;
        long high = high_;
        assert (size % (long)this.compressedBlockSize == 0L);
        while (low <= high) {
            long mid = low + high >>> 1;
            long currPos = mid * (long)this.compressedBlockSize;
            long midVal = searchOffset >= 0L ? this.offsetCoder.decompress(this.getCompressedBits(compressed, currPos + 1L)) : compressed.get(currPos);
            int compare = CompressedNgramMap.compareLongsRaw(midVal, toFind);
            if (compare < 0) {
                low = mid + 1L;
                continue;
            }
            if (compare > 0) {
                high = mid - 1L;
                continue;
            }
            low = mid + 1L;
            break;
        }
        if (low <= 0L) {
            return -1L;
        }
        long i = (low - 1L) * (long)this.compressedBlockSize;
        return i;
    }

    protected void sort(LongArray array, long left0, long right0, int ngramOrder) {
        long left = left0;
        long right = right0 + 1L;
        long pivotIndex = left0 + right0 >>> 1;
        long pivot = array.get(pivotIndex);
        this.swap(pivotIndex, left0, array, ngramOrder);
        while (true) {
            if (++left <= right0 && CompressedNgramMap.compareLongsRaw(array.get(left), pivot) < 0) {
                continue;
            }
            while (CompressedNgramMap.compareLongsRaw(array.get(--right), pivot) > 0) {
            }
            if (left < right) {
                this.swap(left, right, array, ngramOrder);
            }
            if (left > right) break;
        }
        this.swap(left0, right, array, ngramOrder);
        if (left0 < right) {
            this.sort(array, left0, right, ngramOrder);
        }
        if (left < right0) {
            this.sort(array, left, right0, ngramOrder);
        }
    }

    protected void swap(long a, long b, LongArray array, int ngramOrder) {
        this.swap(array, a, b);
        ((CompressibleValueContainer)this.values).swap(a, b, ngramOrder);
    }

    protected void swap(LongArray array, long a, long b) {
        long temp = array.get(a);
        array.set(a, array.get(b));
        array.set(b, temp);
    }

    @Override
    public void trim() {
        this.values.trim();
    }

    @Override
    public void initWithLengths(List<Long> numNGrams) {
    }

    @Override
    public int getMaxNgramOrder() {
        return this.maps.length;
    }

    @Override
    public Iterable<NgramMap.Entry<T>> getNgramsForOrder(final int ngramOrder) {
        return new Iterable<NgramMap.Entry<T>>(){

            @Override
            public Iterator<NgramMap.Entry<T>> iterator() {
                return new Iterator<NgramMap.Entry<T>>(){
                    long currOffset = 0L;

                    @Override
                    public boolean hasNext() {
                        return this.currOffset < CompressedNgramMap.this.maps[ngramOrder].size();
                    }

                    @Override
                    public NgramMap.Entry<T> next() {
                        Object scratch_ = CompressedNgramMap.this.values.getScratchValue();
                        long offset = this.currOffset;
                        int[] ngram = new int[ngramOrder + 1];
                        for (int i = ngramOrder; i >= 0; --i) {
                            Object scratch = i == ngramOrder ? scratch_ : null;
                            long foundKey = CompressedNgramMap.this.decompressSearch(((CompressedNgramMap)CompressedNgramMap.this).maps[i].compressedKeys, -1L, i, scratch, offset);
                            assert (foundKey >= 0L);
                            ngram[ngramOrder - i] = CompressedNgramMap.this.wordOf(foundKey);
                            offset = CompressedNgramMap.this.contextOffsetOf(foundKey);
                        }
                        ++this.currOffset;
                        return new NgramMap.Entry(ngram, scratch_);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Method not yet implemented");
                    }
                };
            }
        };
    }

    @Override
    public long getNumNgrams(int ngramOrder) {
        return this.maps[ngramOrder].size();
    }

    @Override
    public boolean contains(int[] ngram, int startPos, int endPos) {
        return this.getContextOffset(ngram, startPos, endPos, null) >= 0L;
    }

    @Override
    public T get(int[] ngram, int startPos, int endPos) {
        Object val = this.values.getScratchValue();
        long offset = this.getContextOffset(ngram, startPos, endPos, val);
        if (offset < 0L) {
            return null;
        }
        return (T)val;
    }

    @Override
    public CustomWidthArray getValueStoringArray(int ngramOrder) {
        return null;
    }

    @Override
    public void clearStorage() {
        for (int i = 0; i < this.maps.length; ++i) {
            this.maps[i] = null;
        }
    }
}

