/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.awt.Font;
import javajs.util.A4;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.export.UseTable;
import org.jmol.export._VrmlExporter;
import org.jmol.viewer.Viewer;

public class _X3dExporter
extends _VrmlExporter {
    public _X3dExporter() {
        this.useTable = new UseTable("USE='");
    }

    @Override
    protected void outputHeader() {
        this.output("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        this.output("<!DOCTYPE X3D PUBLIC \"ISO//Web3D//DTD X3D 3.1//EN\" \"http://www.web3d.org/specifications/x3d-3.1.dtd\">\n");
        this.output("<X3D profile='Immersive' version='3.1' xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation=' http://www.web3d.org/specifications/x3d-3.1.xsd '>\n");
        this.output("<head>\n");
        this.output("<meta name='title' content=" + PT.esc(this.vwr.ms.modelSetName).replace('<', ' ').replace('>', ' ').replace('&', ' ') + "/>\n");
        this.output("<meta name='description' content='Jmol rendering'/>\n");
        this.output("<meta name='creator' content=' '/>\n");
        this.output("<meta name='created' content='" + this.getExportDate() + "'/>\n");
        this.output("<meta name='generator' content='Jmol " + Viewer.getJmolVersion() + ", http://www.jmol.org'/>\n");
        this.output("<meta name='license' content='http://www.gnu.org/licenses/licenses.html#LGPL'/>\n");
        this.output("</head>\n");
        this.output("<Scene>\n");
        this.output("<NavigationInfo type='EXAMINE'/>\n");
        this.output("<Background skyColor='" + this.rgbFractionalFromColix(this.backgroundColix) + "'/>\n");
        float f = this.getViewpoint();
        this.output("<Viewpoint fieldOfView='" + f);
        this.output("' position='");
        this.cameraPosition.z *= this.exportScale;
        this.output(this.cameraPosition);
        this.output("' orientation='");
        this.output(this.tempP1);
        this.output(" " + -this.viewpoint.angle + "'\n jump='true' description='v1'/>\n");
        this.output("\n  <!-- \n");
        this.output(this.getJmolPerspective());
        this.output("\n  -->\n\n");
        this.commentChar = null;
        this.outputInitialTransform();
    }

    @Override
    protected void outputAttrPt(String string, T3 t3) {
        this.output(" " + string + "='" + t3.x + " " + t3.y + " " + t3.z + "'");
    }

    @Override
    protected void pushMatrix() {
        this.output("<Transform ");
    }

    @Override
    protected void popMatrix() {
        this.output("</Transform>\n");
    }

    @Override
    protected void outputAttr(String string, float f, float f2, float f3) {
        this.output(" " + string + "='" + _X3dExporter.round(f) + " " + _X3dExporter.round(f2) + " " + _X3dExporter.round(f3) + "'");
    }

    @Override
    protected void outputRotation(A4 a4) {
        this.output(" rotation='" + a4.x + " " + a4.y + " " + a4.z + " " + a4.angle + "'");
    }

    @Override
    protected void outputFooter() {
        this.useTable = null;
        this.popMatrix();
        this.popMatrix();
        this.output("</Scene>\n");
        this.output("</X3D>\n");
    }

    @Override
    protected void outputAppearance(short s, boolean bl) {
        String string = this.getDef(String.valueOf(bl ? "T" : "") + s);
        this.output("<Appearance ");
        if (string.charAt(0) == '_') {
            String string2 = this.rgbFractionalFromColix(s);
            this.output("DEF='" + string + "'><Material diffuseColor='");
            if (bl) {
                this.output("0 0 0' specularColor='0 0 0' ambientIntensity='0.0' shininess='0.0' emissiveColor='" + string2 + "'/>");
            } else {
                this.output(String.valueOf(string2) + "' transparency='" + _X3dExporter.translucencyFractionalFromColix(s) + "'/>");
            }
        } else {
            this.output(String.valueOf(string) + ">");
        }
        this.output("</Appearance>");
    }

    @Override
    protected void outputChildShapeStart() {
        this.outputShapeStart();
    }

    @Override
    protected void outputShapeStart() {
        this.output("<Shape>");
        this.outputFaceSetStart();
    }

    @Override
    protected void outputChildStart() {
    }

    @Override
    protected void outputChildClose() {
    }

    @Override
    protected void outputDefChildFaceSet(String string) {
        if (string != null) {
            this.output("DEF='" + string + "'");
        }
    }

    @Override
    protected void outputFaceSetStart() {
        this.output("<IndexedFaceSet ");
    }

    @Override
    protected void outputFaceSetClose() {
        this.output("</IndexedFaceSet>\n");
    }

    @Override
    protected void outputUseChildClose(String string) {
        this.output(String.valueOf(string) + "/>");
    }

    @Override
    protected void outputChildShapeClose() {
        this.outputShapeClose();
    }

    @Override
    protected void outputShapeClose() {
        this.output("</Shape>\n");
    }

    @Override
    protected void outputCloseTag() {
        this.output(">\n");
    }

    @Override
    protected void outputTriangle(T3 t3, T3 t32, T3 t33, short s) {
        this.output("<Shape>\n");
        this.output("<IndexedFaceSet solid='false' ");
        this.output("coordIndex='0 1 2 -1'>");
        this.output("<Coordinate point='");
        this.output(t3);
        this.output(" ");
        this.output(t32);
        this.output(" ");
        this.output(t33);
        this.output("'/>");
        this.output("</IndexedFaceSet>\n");
        this.outputAppearance(s, false);
        this.output("\n</Shape>\n");
    }

    @Override
    protected void outputCircle(P3 p3, P3 p32, float f, short s, boolean bl) {
        if (bl) {
            this.pushMatrix();
            this.output("translation='");
            this.tempV1.ave(this.tempP3, p3);
            this.output(this.tempV1);
            this.output("'><Billboard axisOfRotation='0 0 0'>");
            this.pushMatrix();
            this.output("rotation='1 0 0 1.5708'");
            float f2 = p3.distance(p32);
            this.outputAttr("scale", f, f2, f);
            this.output(">");
            this.outputCylinderChildScaled(s, (byte)2);
            this.popMatrix();
            this.output("</Billboard>");
            this.popMatrix();
            return;
        }
        String string = this.getDef("C" + s + "_" + f);
        this.pushMatrix();
        this.outputTransRot(this.tempP3, p3, 0, 0, 1);
        this.tempP3.set(1.0f, 1.0f, 1.0f);
        this.tempP3.scale(f);
        this.outputAttr("scale", this.tempP3.x, this.tempP3.y, this.tempP3.z);
        this.output(">\n<Billboard ");
        if (string.charAt(0) == '_') {
            this.output("DEF='" + string + "'");
            this.output(" axisOfRotation='0 0 0'>");
            this.pushMatrix();
            this.output("<Shape><Extrusion beginCap='false' convex='false' endCap='false' creaseAngle='1.57'");
            this.output(" crossSection='");
            float f3 = (float)Math.PI / 180;
            float f4 = 0.02f / f;
            int n = 0;
            while (n <= 360) {
                this.output(String.valueOf(_X3dExporter.round(Math.cos((float)n * f3) * (double)f4)) + " ");
                this.output(String.valueOf(_X3dExporter.round(Math.sin((float)n * f3) * (double)f4)) + " ");
                n += 10;
            }
            this.output("' spine='");
            n = 0;
            while (n <= 360) {
                this.output(String.valueOf(_X3dExporter.round(Math.cos((float)n * f3))) + " ");
                this.output(String.valueOf(_X3dExporter.round(Math.sin((float)n * f3))) + " 0 ");
                n += 10;
            }
            this.output("'/>");
            this.outputAppearance(s, false);
            this.output("</Shape>");
            this.popMatrix();
        } else {
            this.output(String.valueOf(string) + ">");
        }
        this.output("</Billboard>\n");
        this.popMatrix();
    }

    @Override
    protected void outputGeometry(T3[] t3Array, T3[] t3Array2, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, BS bS, int n3, Lst<Short> lst, Map<Short, Integer> map, P3 p3) {
        this.output(" creaseAngle='0.5'\n");
        if (sArray2 != null) {
            this.output(" colorPerVertex='false'\n");
        }
        this.output("coordIndex='\n");
        int[] nArray2 = new int[n];
        this.getCoordinateMap(t3Array, nArray2, null);
        this.outputIndices(nArray, nArray2, n2, bS, n3);
        this.output("'\n");
        Lst<String> lst2 = null;
        if (t3Array2 != null) {
            lst2 = new Lst<String>();
            nArray2 = this.getNormalMap(t3Array2, n, null, lst2);
            this.output("  solid='false'\n  normalPerVertex='true'\n  normalIndex='\n");
            this.outputIndices(nArray, nArray2, n2, bS, n3);
            this.output("'\n");
        }
        nArray2 = null;
        if (lst != null) {
            this.output("  colorIndex='\n");
            this.outputColorIndices(nArray, n2, bS, n3, map, sArray, sArray2);
            this.output("'\n");
        }
        this.output(">\n");
        this.output("<Coordinate point='\n");
        this.outputVertices(t3Array, n, p3);
        this.output("'/>\n");
        if (t3Array2 != null) {
            this.output("<Normal vector='\n");
            this.outputNormals(lst2);
            lst2 = null;
            this.output("'/>\n");
        }
        if (lst != null) {
            this.output("<Color color='\n");
            this.outputColors(lst);
            this.output("'/>\n");
        }
    }

    @Override
    protected void outputTextPixel(P3 p3, int n) {
    }

    @Override
    void plotText(int n, int n2, int n3, short s, String string, Font font) {
    }
}

