/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Map;
import javajs.awt.GenericImageDialog;
import javajs.util.PT;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.awt.Platform;
import org.jmol.viewer.Viewer;

public class ImageDialog
extends JDialog
implements GenericImageDialog,
WindowListener,
ActionListener {
    private JMenuBar menubar;
    protected Image image;
    protected Viewer vwr;
    protected Canvas canvas;
    private String title;
    private Map<String, GenericImageDialog> imageMap;
    private JmolAppConsoleInterface console;

    public ImageDialog(Viewer viewer, String string, Map<String, GenericImageDialog> map) {
        super(Platform.getWindow((Container)viewer.display) instanceof JFrame ? (JFrame)Platform.getWindow((Container)viewer.display) : null, string, false);
        this.vwr = viewer;
        this.setResizable(false);
        this.console = viewer.getConsole();
        this.addWindowListener(this);
        this.title = string;
        this.imageMap = map;
        map.put(string, this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(new Color(255, 0, 0));
        this.canvas = new ImageCanvas();
        jPanel.add((Component)this.canvas, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.menubar = new JMenuBar();
        this.menubar.add(this.createMenu());
        this.setJMenuBar(this.menubar);
        jPanel2.add((Component)jPanel, "Center");
        this.getContentPane().add(jPanel2);
        this.pack();
        this.setLocation(100, 100);
        this.setVisible(true);
    }

    private JMenu createMenu() {
        String[] stringArray = PT.getTokens("saveas close");
        this.vwr.getConsole();
        JMenu jMenu = (JMenu)this.console.newJMenu("file");
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            JMenuItem jMenuItem = this.createMenuItem(string);
            jMenu.add(jMenuItem);
            ++n;
        }
        jMenu.setVisible(true);
        return jMenu;
    }

    private JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem = (JMenuItem)this.console.newJMenuItem(string);
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this);
        jMenuItem.setVisible(true);
        return jMenuItem;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("close")) {
            this.closeMe();
        } else if (string.equals("saveas")) {
            this.saveAs();
        }
    }

    private void saveAs() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                String string = ImageDialog.this.vwr.dialogAsk("Save Image", "jmol.png", hashtable);
                if (string == null) {
                    return;
                }
                String string2 = "PNG";
                int n = string.lastIndexOf(".");
                if (n > 0) {
                    string2 = string.substring(n + 1).toUpperCase();
                }
                hashtable.put("fileName", string);
                hashtable.put("type", string2);
                hashtable.put("image", ImageDialog.this.image);
                ImageDialog.this.vwr.showString(ImageDialog.this.vwr.processWriteOrCapture(hashtable), false);
            }
        }){}.start();
    }

    @Override
    public void closeMe() {
        this.imageMap.remove(this.title);
        this.dispose();
    }

    @Override
    public void setImage(Object object) {
        if (object == null) {
            this.closeMe();
            return;
        }
        this.image = (Image)object;
        int n = this.image.getWidth(null);
        int n2 = this.image.getHeight(null);
        this.setTitle(String.valueOf(this.title) + " [" + n + " x " + n2 + "]");
        Dimension dimension = new Dimension(n, n2);
        this.canvas.setSize(dimension);
        this.pack();
        this.repaint();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.closeMe();
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    class ImageCanvas
    extends Canvas {
        ImageCanvas() {
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.drawImage(ImageDialog.this.image, 0, 0, null);
        }
    }
}

