/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"
#include"symm.h"
#include"getput.h"


main (int argc, char *argv[])
{

	matrix_TYP *Mat;
        matrix_TYP *SV;
        int min;

        read_header(argc, argv);
        if(FILEANZ != 1)
        {
           printf("Usage: %s 'file' [-n]\n",argv[0]);
           printf("\n");
           printf("file: matrix_TYP containing a positive definite symmetric matrix.\n");
           printf("\n");
           printf("Calculates the shortest vectors of the given form. They are output as\n");
           printf("a matrix whose rows are the shortest vectors of the form.\n");
           printf("\n");
           printf("Options:\n");
           printf("-n     : Echo the norm of the vectors in the last column of the vector.\n");
           printf("\n");
           printf("Cf: Isometry, Aut_grp, Short.\n");
           if (is_option('h')){
              exit(0);
           }
           else{
              exit(31);
           }
        }
	Mat = get_mat (FILENAMES[0]);
        SV = shortest(Mat, &min);
        if(is_option('n') == TRUE)
           SV->cols++;
        put_mat(SV, NULL, "shortest vectors", 0);

   exit(0);
}
