define(["cardBuilder","serverNotifications","events","imageLoader","focusManager","loading","connectionManager","apphost","datetime","dom","layoutManager","scrollHelper","emby-itemscontainer"],function(cardBuilder,serverNotifications,events,imageLoader,focusManager,loading,connectionManager,appHost,datetime,dom,layoutManager,scrollHelper){"use strict";function enableScrollX(){return layoutManager.mobile}function LiveTvScheduleTab(view,params){this.view=view,this.params=params,this.apiClient=connectionManager.getApiClient(params.serverId),initLayout(view),this.activeRecordingsItemsContainer=view.querySelector(".activeRecordings .itemsContainer"),this.activeRecordingsItemsContainer.fetchData=fetchActiveRecordings.bind(this),this.activeRecordingsItemsContainer.getItemsHtml=getActiveRecordingsHtml.bind(this),this.activeRecordingsItemsContainer.parentContainer=dom.parentWithClass(this.activeRecordingsItemsContainer,"verticalSection")}function initLayout(view){for(var containers=view.querySelectorAll(".autoScrollSection"),i=0,length=containers.length;i<length;i++){var html,section=containers[i];html=enableScrollX()?'<div is="emby-scroller" class="padded-top-focusscale padded-bottom-focusscale" data-framesize="matchgrandparent" data-centerfocus="card"><div is="emby-itemscontainer" class="itemsContainer scrollSlider focuscontainer-x padded-left padded-right" data-monitor="timers"></div></div>':'<div is="emby-itemscontainer" class="itemsContainer padded-left padded-right vertical-wrap" data-monitor="timers"></div>',section.insertAdjacentHTML("beforeend",html)}}function getBackdropShape(){return enableScrollX()?"overflowBackdrop":"backdrop"}function getTimersHtml(timers){var i,length,items=timers.map(function(t){return t.Type="Timer",t}),groups=[],currentGroupName="",currentGroup=[],primaryImageAspectRatio=imageLoader.getPrimaryImageAspectRatio(items)||1;for(i=0,length=items.length;i<length;i++){var item=items[i],dateText="";if(item.StartDate)try{var premiereDate=datetime.parseISO8601Date(item.StartDate,!0);dateText=datetime.toLocaleDateString(premiereDate,{weekday:"long",month:"short",day:"numeric"})}catch(err){}dateText!==currentGroupName?(currentGroup.length&&groups.push({name:currentGroupName,items:currentGroup}),currentGroupName=dateText,currentGroup=[item]):currentGroup.push(item)}currentGroup.length&&groups.push({name:currentGroupName,items:currentGroup});var html="";for(i=0,length=groups.length;i<length;i++){var group=groups[i];html+='<div class="verticalSection">',html+='<h2 class="sectionTitle sectionTitle-cards padded-left">'+group.name+"</h2>",enableScrollX()?html+='<div is="emby-itemscontainer" class="itemsContainer scrollX hiddenScrollX padded-left padded-right padded-top-focusscale padded-bottom-focusscale">':html+='<div is="emby-itemscontainer" class="itemsContainer vertical-wrap padded-left padded-right">';var cardLayout=primaryImageAspectRatio>=1.5;html+=cardBuilder.getCardsHtml({items:group.items,shape:cardLayout?getBackdropShape():enableScrollX()?"autooverflow":"auto",showParentTitleOrTitle:!0,showAirTime:!0,showAirEndTime:!0,showChannelName:!1,cardLayout:cardLayout,centerText:!cardLayout,action:"edit",cardFooterAside:!1,overlayText:!1,showChannelLogo:cardLayout,preferThumb:!!cardLayout||null,coverImage:null}),html+="</div>",html+="</div>"}return html}function renderTimers(elem,items){var html=getTimersHtml(items);html?elem.classList.remove("hide"):elem.classList.add("hide"),elem.querySelector(".upcomingRecordings").innerHTML=html,imageLoader.lazyChildren(elem)}function fetchActiveRecordings(){var apiClient=this.apiClient;return apiClient.getLiveTvRecordings({UserId:apiClient.getCurrentUserId(),IsInProgress:!0,Fields:"CanDelete,PrimaryImageAspectRatio,BasicSyncInfo",EnableTotalRecordCount:!1,EnableImageTypes:"Primary,Thumb,Backdrop"})}function getActiveRecordingsHtml(items){return cardBuilder.getCardsHtml({items:items,shape:enableScrollX()?"autooverflow":"auto",cardLayout:!1,showParentTitle:!1,showParentTitleOrTitle:!0,showTitle:!1,showAirTime:!0,showAirEndTime:!0,showChannelName:!0,preferThumb:"auto",overlayText:!1,centerText:!0})}function onServerNotification(){this.paused?this.needsRefresh=!0:this.onResume({refresh:!0})}return LiveTvScheduleTab.prototype.onResume=function(options){if(this.paused=!1,!this.serverNotificationHandler){var serverNotificationHandler=onServerNotification.bind(this);events.on(serverNotifications,"TimerCreated",serverNotificationHandler),events.on(serverNotifications,"TimerCancelled",serverNotificationHandler),events.on(serverNotifications,"RecordingStarted",serverNotificationHandler),events.on(serverNotifications,"RecordingEnded",serverNotificationHandler),this.serverNotificationHandler=serverNotificationHandler}var apiClient=this.apiClient,promises=[];options=options||{},this.needsRefresh&&(options.refresh=!0,this.needsRefresh=!1),promises.push(this.activeRecordingsItemsContainer.resume(options));var view=this.view;options.refresh&&(promises.push(apiClient.getLiveTvTimers({IsActive:!1,IsScheduled:!0})),promises[1].then(function(result){return renderTimers(view,result.Items),Promise.resolve()}));var scroller=view.querySelector(".scrollFrameY");Promise.all(promises).then(function(){options.autoFocus&&focusManager.autoFocus(scroller)})},LiveTvScheduleTab.prototype.onPause=function(){this.paused=!0,this.activeRecordingsItemsContainer.pause()},LiveTvScheduleTab.prototype.destroy=function(){var serverNotificationHandler=this.serverNotificationHandler;serverNotificationHandler&&(events.off(serverNotifications,"TimerCreated",serverNotificationHandler),events.off(serverNotifications,"TimerCancelled",serverNotificationHandler),events.off(serverNotifications,"RecordingStarted",serverNotificationHandler),events.off(serverNotifications,"RecordingEnded",serverNotificationHandler),this.serverNotificationHandler=null),this.view=null,this.params=null,this.apiClient=null,this.activeRecordingsItemsContainer=null},LiveTvScheduleTab});