/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.JavaDateMathParser;

class JavaDateFormatter
implements DateFormatter {
    private static final Map<TemporalField, Long> ROUND_UP_BASE_FIELDS = new HashMap<TemporalField, Long>(6);
    private final String format;
    private final DateTimeFormatter printer;
    private final DateTimeFormatter parser;
    private final DateTimeFormatter roundupParser;

    private JavaDateFormatter(String format, DateTimeFormatter printer, DateTimeFormatter roundupParser, DateTimeFormatter parser) {
        ROUND_UP_BASE_FIELDS.put(ChronoField.MONTH_OF_YEAR, 1L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.DAY_OF_MONTH, 1L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.HOUR_OF_DAY, 23L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.MINUTE_OF_HOUR, 59L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.SECOND_OF_MINUTE, 59L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.NANO_OF_SECOND, 999999999L);
        this.format = "8" + format;
        this.printer = printer;
        this.roundupParser = roundupParser;
        this.parser = parser;
    }

    JavaDateFormatter(String format, DateTimeFormatter printer, DateTimeFormatter ... parsers) {
        this(format, printer, (DateTimeFormatterBuilder builder) -> ROUND_UP_BASE_FIELDS.forEach(builder::parseDefaulting), parsers);
    }

    JavaDateFormatter(String format, DateTimeFormatter printer, Consumer<DateTimeFormatterBuilder> roundupParserConsumer, DateTimeFormatter ... parsers) {
        DateTimeFormatterBuilder builder;
        ROUND_UP_BASE_FIELDS.put(ChronoField.MONTH_OF_YEAR, 1L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.DAY_OF_MONTH, 1L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.HOUR_OF_DAY, 23L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.MINUTE_OF_HOUR, 59L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.SECOND_OF_MINUTE, 59L);
        ROUND_UP_BASE_FIELDS.put(ChronoField.NANO_OF_SECOND, 999999999L);
        if (printer == null) {
            throw new IllegalArgumentException("printer may not be null");
        }
        long distinctZones = Arrays.stream(parsers).map(DateTimeFormatter::getZone).distinct().count();
        if (distinctZones > 1L) {
            throw new IllegalArgumentException("formatters must have the same time zone");
        }
        long distinctLocales = Arrays.stream(parsers).map(DateTimeFormatter::getLocale).distinct().count();
        if (distinctLocales > 1L) {
            throw new IllegalArgumentException("formatters must have the same locale");
        }
        if (parsers.length == 0) {
            this.parser = printer;
        } else if (parsers.length == 1) {
            this.parser = parsers[0];
        } else {
            builder = new DateTimeFormatterBuilder();
            for (DateTimeFormatter parser : parsers) {
                builder.appendOptional(parser);
            }
            this.parser = builder.toFormatter(Locale.ROOT);
        }
        this.format = "8" + format;
        this.printer = printer;
        builder = new DateTimeFormatterBuilder();
        if (!format.contains("||")) {
            builder.append(this.parser);
        }
        roundupParserConsumer.accept(builder);
        DateTimeFormatter roundupFormatter = builder.toFormatter(this.parser.getLocale());
        if (printer.getZone() != null) {
            roundupFormatter = roundupFormatter.withZone(printer.getZone());
        }
        this.roundupParser = roundupFormatter;
    }

    DateTimeFormatter getRoundupParser() {
        return this.roundupParser;
    }

    DateTimeFormatter getParser() {
        return this.parser;
    }

    DateTimeFormatter getPrinter() {
        return this.printer;
    }

    @Override
    public TemporalAccessor parse(String input) {
        if (Strings.isNullOrEmpty(input)) {
            throw new IllegalArgumentException("cannot parse empty date");
        }
        return this.parser.parse(input);
    }

    @Override
    public DateFormatter withZone(ZoneId zoneId) {
        if (zoneId.equals(this.parser.getZone())) {
            return this;
        }
        return new JavaDateFormatter(this.format, this.printer.withZone(zoneId), this.roundupParser.withZone(zoneId), this.parser.withZone(zoneId));
    }

    @Override
    public DateFormatter withLocale(Locale locale) {
        if (locale.equals(this.parser.getLocale())) {
            return this;
        }
        return new JavaDateFormatter(this.format, this.printer.withLocale(locale), this.roundupParser.withLocale(locale), this.parser.withLocale(locale));
    }

    @Override
    public String format(TemporalAccessor accessor) {
        return this.printer.format(accessor);
    }

    @Override
    public String pattern() {
        return this.format;
    }

    @Override
    public Locale locale() {
        return this.printer.getLocale();
    }

    @Override
    public ZoneId zone() {
        return this.printer.getZone();
    }

    @Override
    public DateMathParser toDateMathParser() {
        return new JavaDateMathParser(this.format, this.parser, this.roundupParser);
    }

    public int hashCode() {
        return Objects.hash(this.locale(), this.printer.getZone(), this.format);
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        JavaDateFormatter other = (JavaDateFormatter)obj;
        return Objects.equals(this.format, other.format) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.printer.getZone(), other.printer.getZone());
    }

    public String toString() {
        return String.format(Locale.ROOT, "format[%s] locale[%s]", this.format, this.locale());
    }
}

