/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class Block
extends Statement {
    private final ASTNode.NodeList<Statement> statements = new ASTNode.NodeList(this, STATEMENTS_PROPERTY);
    private boolean isCurly;
    private BodyStartSymbol bodyStartSymbol = BodyStartSymbol.NONE;
    public static final ChildListPropertyDescriptor STATEMENTS_PROPERTY = new ChildListPropertyDescriptor(Block.class, "statements", Statement.class, true);
    public static final SimplePropertyDescriptor IS_CURLY_PROPERTY = new SimplePropertyDescriptor(Block.class, "isCurly", Boolean.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(2);
        properyList.add(STATEMENTS_PROPERTY);
        properyList.add(IS_CURLY_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public Block(int start, int end, AST ast, List<Statement> statements, boolean isCurly) {
        super(start, end, ast);
        if (statements == null) {
            throw new IllegalArgumentException();
        }
        this.setIsCurly(isCurly);
        this.statements.addAll(statements);
    }

    public Block(int start, int end, AST ast, List<Statement> statements) {
        this(start, end, ast, statements, true);
    }

    public Block(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.statements) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.statements) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.statements) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<Block");
        this.appendInterval(buffer);
        buffer.append(" isCurly='").append(this.isCurly).append("'>\n");
        for (ASTNode aSTNode : this.statements) {
            aSTNode.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</Block>");
    }

    @Override
    public int getType() {
        return 6;
    }

    public boolean isCurly() {
        return this.isCurly;
    }

    @Deprecated
    public void setIsCurly(boolean isCurly) {
        this.preValueChange(IS_CURLY_PROPERTY);
        this.isCurly = isCurly;
        if (isCurly) {
            this.setBracketAsBodyStartSymbol();
        } else {
            this.setColonAsBodyStartSymbol();
        }
        this.postValueChange(IS_CURLY_PROPERTY);
    }

    public boolean isBracketed() {
        return this.bodyStartSymbol == BodyStartSymbol.BRACKLET;
    }

    public void setBracketAsBodyStartSymbol() {
        this.bodyStartSymbol = BodyStartSymbol.BRACKLET;
    }

    public boolean isColon() {
        return this.bodyStartSymbol == BodyStartSymbol.COLON;
    }

    public void setColonAsBodyStartSymbol() {
        this.bodyStartSymbol = BodyStartSymbol.COLON;
    }

    public void clearBodyStartSymbol() {
        this.bodyStartSymbol = BodyStartSymbol.NONE;
    }

    public List<Statement> statements() {
        return this.statements;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List<Statement> statements = ASTNode.copySubtrees(target, this.statements());
        return new Block(this.getStart(), this.getEnd(), target, statements, this.isCurly());
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final List<? extends ASTNode> internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == STATEMENTS_PROPERTY) {
            return this.statements();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == IS_CURLY_PROPERTY) {
            if (get) {
                return this.isCurly();
            }
            this.setIsCurly(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    private static enum BodyStartSymbol {
        NONE,
        BRACKLET,
        COLON;

    }
}

