/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.eventimpl;

import java.util.Vector;
import org.eclipse.wst.css.core.internal.event.ICSSStyleListener;
import org.eclipse.wst.css.core.internal.event.ICSSStyleNotifier;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;

public class CSSStyleEventDeliverer {
    private Vector fVisited = new Vector();
    private ICSSModel fSrcModel;
    private ICSSSelector[] fRemoved;
    private ICSSSelector[] fAdded;
    private String fMedia;

    public void fire(ICSSModel srcModel, ICSSSelector[] removed, ICSSSelector[] added, String media) {
        if (srcModel == null || srcModel.getStyleListeners() == null) {
            return;
        }
        this.fSrcModel = srcModel;
        this.fRemoved = removed;
        this.fAdded = added;
        this.fMedia = media;
        this.fVisited.clear();
        this.fVisited.add(srcModel);
        Object[] listeners = srcModel.getStyleListeners().toArray();
        int i = 0;
        while (i < listeners.length) {
            this.visit((ICSSStyleListener)listeners[i]);
            ++i;
        }
    }

    public void fireTo(ICSSStyleListener listener, ICSSModel srcModel, ICSSSelector[] removed, ICSSSelector[] added, String media) {
        this.fSrcModel = srcModel;
        this.fRemoved = removed;
        this.fAdded = added;
        this.fMedia = media;
        this.fVisited.clear();
        this.visit(listener);
    }

    public void fireUpdate(ICSSModel srcModel) {
        if (srcModel == null || srcModel.getStyleListeners() == null) {
            return;
        }
        this.fSrcModel = srcModel;
        this.fVisited.clear();
        this.fVisited.add(srcModel);
        Object[] listeners = srcModel.getStyleListeners().toArray();
        int i = 0;
        while (i < listeners.length) {
            this.visitUpdate((ICSSStyleListener)listeners[i]);
            ++i;
        }
    }

    public void fireUpdateTo(ICSSStyleListener listener, ICSSModel srcModel) {
        if (srcModel == null || srcModel.getStyleListeners() == null) {
            return;
        }
        this.fSrcModel = srcModel;
        this.fVisited.clear();
        this.visitUpdate(listener);
    }

    protected void visit(ICSSStyleListener listener) {
        ICSSStyleNotifier notifier;
        if (listener == null || this.fVisited.contains(listener)) {
            return;
        }
        listener.styleChanged(this.fSrcModel, this.fRemoved, this.fAdded, this.fMedia);
        this.fVisited.add(listener);
        if (listener instanceof ICSSStyleNotifier && (notifier = (ICSSStyleNotifier)listener).getStyleListeners() != null) {
            Object[] listeners = notifier.getStyleListeners().toArray();
            int i = 0;
            while (i < listeners.length) {
                this.visit((ICSSStyleListener)listeners[i]);
                ++i;
            }
        }
    }

    protected void visitUpdate(ICSSStyleListener listener) {
        ICSSStyleNotifier notifier;
        if (listener == null || this.fVisited.contains(listener)) {
            return;
        }
        listener.styleUpdate(this.fSrcModel);
        this.fVisited.add(listener);
        if (listener instanceof ICSSStyleNotifier && (notifier = (ICSSStyleNotifier)listener).getStyleListeners() != null) {
            Object[] listeners = notifier.getStyleListeners().toArray();
            int i = 0;
            while (i < listeners.length) {
                this.visitUpdate((ICSSStyleListener)listeners[i]);
                ++i;
            }
        }
    }
}

