/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.engine.transformer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListManager;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;

public class ViewSelectionTransformer
implements ITransformer {
    protected Controller controller;
    protected String listManagerKey;
    protected String viewKey;

    public ViewSelectionTransformer(Controller controller, String listManagerKey, String viewKey) {
        this.controller = controller;
        this.listManagerKey = listManagerKey;
        this.viewKey = viewKey;
    }

    public Hashtable normalize(Hashtable properties) {
        Vector<String> normalizedViewIds = new Vector<String>();
        NodeManager nodeManager = this.controller.getCurrentPerspective().getNodeManager();
        Node currNode = nodeManager.getSelectedNode();
        TreeElement currElement = currNode.getTreeElement();
        Object listManagerObj = currElement.getPropertyAsObject(this.listManagerKey);
        if (listManagerObj instanceof ListManager) {
            ListManager listManager = (ListManager)listManagerObj;
            String[] viewIds = this.getViewValues(properties);
            int i = 0;
            while (i < viewIds.length) {
                Object object;
                ListElement listElement = null;
                try {
                    listElement = listManager.getElementWithViewId(Integer.parseInt(viewIds[i]));
                }
                catch (NumberFormatException numberFormatException) {}
                if (listElement != null && (object = listElement.getObject()) != null && object instanceof Element) {
                    Element element = (Element)object;
                    normalizedViewIds.add(element.getName());
                }
                ++i;
            }
        }
        properties.put(this.viewKey, normalizedViewIds.toArray(new String[0]));
        return properties;
    }

    public Hashtable deNormalize(Hashtable properties) {
        int size;
        TreeElement currElement;
        Object listManagerObj;
        Vector<String> viewIds = new Vector<String>();
        Node currNode = this.controller.getCurrentPerspective().getNodeManager().getSelectedNode();
        if (currNode != null && (listManagerObj = (currElement = currNode.getTreeElement()).getPropertyAsObject(this.listManagerKey)) instanceof ListManager) {
            ListManager listManager = (ListManager)listManagerObj;
            String[] normalizedViewIds = this.getViewValues(properties);
            int i = 0;
            while (i < normalizedViewIds.length) {
                Enumeration e = listManager.getListElements();
                while (e.hasMoreElements()) {
                    ListElement listElement = (ListElement)e.nextElement();
                    Element element = (Element)listElement.getObject();
                    if (element == null || !normalizedViewIds[i].equals(element.getName())) continue;
                    viewIds.add(String.valueOf(listElement.getViewId()));
                    break;
                }
                ++i;
            }
        }
        if ((size = viewIds.size()) == 1) {
            properties.put(this.viewKey, viewIds.get(0));
        } else if (size > 1) {
            properties.put(this.viewKey, viewIds.toArray(new String[0]));
        }
        return properties;
    }

    private String[] getViewValues(Hashtable properties) {
        Object viewValueObj = properties.get(this.viewKey);
        String[] viewValues = viewValueObj == null ? new String[]{} : (viewValueObj.getClass().isArray() ? (String[])viewValueObj : new String[]{(String)viewValueObj});
        return viewValues;
    }
}

