/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.net.URI;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IPositionConverter;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.StatusLineHandler;
import org.eclipse.cdt.internal.ui.viewsupport.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorOpener {
    public static void open(IWorkbenchPage page, IFile file, IRegion region, long timestamp) {
        if (file.getLocationURI() != null) {
            IEditorPart editor = null;
            if (timestamp == 0L) {
                timestamp = file.getLocalTimeStamp();
            }
            try {
                if (!file.exists()) {
                    IWorkbenchPartSite site = page.getActivePart().getSite();
                    EditorOpener.showStatus(site, 3000, NLS.bind((String)Messages.EditorOpener_fileDoesNotExist, (Object)file.getName()));
                    return;
                }
                editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)false);
            }
            catch (PartInitException e) {
                CUIPlugin.log(e);
            }
            EditorOpener.selectRegion(file.getFullPath(), region, timestamp, editor);
        }
    }

    private static void showStatus(final IWorkbenchPartSite site, int duration, String msg) {
        StatusLineHandler.showStatusLineMessage((IWorkbenchSite)site, msg);
        Display.getCurrent().timerExec(duration, new Runnable(){

            @Override
            public void run() {
                StatusLineHandler.clearStatusLine((IWorkbenchSite)site);
            }
        });
    }

    private static void selectRegion(IPath filebufferKey, IRegion region, long timestamp, IEditorPart editor) {
        if (editor instanceof ITextEditor) {
            ITextEditor te = (ITextEditor)editor;
            IPositionConverter pc = CCorePlugin.getPositionTrackerManager().findPositionConverter(filebufferKey, timestamp);
            if (pc != null) {
                region = pc.historicToActual(region);
            }
            te.selectAndReveal(region.getOffset(), region.getLength());
        }
    }

    private static void selectRegion(URI locationURI, IRegion region, long timestamp, IEditorPart editor) {
        if (editor instanceof ITextEditor) {
            ITextEditor te = (ITextEditor)editor;
            IPositionConverter pc = CCorePlugin.getPositionTrackerManager().findPositionConverter(locationURI, timestamp);
            if (pc != null) {
                region = pc.historicToActual(region);
            }
            te.selectAndReveal(region.getOffset(), region.getLength());
        }
    }

    public static void openExternalFile(IWorkbenchPage page, IPath location, IRegion region, long timestamp) {
        IEditorPart editor = null;
        try {
            editor = EditorUtility.openInEditor(location, null);
            if (timestamp == 0L) {
                timestamp = location.toFile().lastModified();
            }
            EditorOpener.selectRegion(location, region, timestamp, editor);
        }
        catch (PartInitException e) {
            CUIPlugin.log(e);
        }
    }

    public static void openExternalFile(IWorkbenchPage page, URI locationURI, IRegion region, long timestamp, ICElement context) {
        IEditorPart editor = null;
        try {
            editor = EditorUtility.openInEditor(locationURI, context);
            if (timestamp == 0L) {
                try {
                    timestamp = EFS.getStore((URI)locationURI).fetchInfo().getLastModified();
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                }
            }
            EditorOpener.selectRegion(locationURI, region, timestamp, editor);
        }
        catch (PartInitException e) {
            CUIPlugin.log(e);
        }
    }

    public static void open(IWorkbenchPage page, ICElement element) throws CModelException {
        if (element instanceof ISourceReference) {
            ISourceReference sr = (ISourceReference)element;
            ITranslationUnit tu = sr.getTranslationUnit();
            ISourceRange range = sr.getSourceRange();
            long timestamp = 0L;
            if (tu.isWorkingCopy() || element instanceof ICElementHandle) {
                timestamp = -1L;
            }
            EditorOpener.open(page, tu, new Region(range.getIdStartPos(), range.getIdLength()), timestamp);
        }
    }

    public static void open(IWorkbenchPage page, ITranslationUnit tu, Region region, long timestamp) {
        if (tu != null) {
            IResource r = tu.getResource();
            if (r instanceof IFile) {
                if (r.getLocationURI() != null) {
                    EditorOpener.open(page, (IFile)r, (IRegion)region, timestamp);
                }
            } else {
                IPath location = tu.getPath();
                if (location != null) {
                    EditorOpener.openExternalFile(page, location, (IRegion)region, timestamp);
                }
            }
        }
    }
}

