/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sample.database;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IWorkbenchWindowInitializer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.IOUtils;

public class WorkbenchInitializerCreateSampleDatabase
implements IWorkbenchWindowInitializer {
    private static final String PROP_SAMPLE_DB_CANCELED = "sample.database.canceled";
    private static final String SAMPLE_DB1_ID = "dbeaver-sample-database-sqlite-1";
    private static final String SAMPLE_DB1_FOLDER = "sample-database-sqlite-1";
    private static final String SAMPLE_DB_FILE_NAME = "Chinook.db";
    private static final String SAMPLE_DB_SOURCE_PATH = "data/Chinook.db";
    private static final Log log = Log.getLog(WorkbenchInitializerCreateSampleDatabase.class);

    public void initializeWorkbenchWindow(IWorkbenchWindow window) {
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean(PROP_SAMPLE_DB_CANCELED)) {
            return;
        }
        if (DataSourceRegistry.getAllDataSources().size() > 1) {
            return;
        }
        IProject activeProject = DBWorkbench.getPlatform().getProjectManager().getActiveProject();
        if (activeProject == null) {
            return;
        }
        if (DBUtils.findDataSource((String)SAMPLE_DB1_ID) != null) {
            return;
        }
        if (!UIUtils.confirmAction((Shell)window.getShell(), (String)"Create Sample Database", (String)("Do you want to create sample database?\nIt can be used as an example to explore basic " + GeneralUtils.getProductName() + " features."))) {
            DBWorkbench.getPlatform().getPreferenceStore().setValue(PROP_SAMPLE_DB_CANCELED, true);
            return;
        }
        this.createSampleDatabase(activeProject);
    }

    private void createSampleDatabase(IProject project) {
        DBPDataSourceRegistry dsRegistry = DBWorkbench.getPlatform().getProjectManager().getDataSourceRegistry(project);
        DBPDataSourceContainer dataSource = dsRegistry.getDataSource(SAMPLE_DB1_ID);
        if (dataSource != null) {
            return;
        }
        DataSourceProviderDescriptor genericDSProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider("generic");
        if (genericDSProvider == null) {
            log.error((Object)"Can't find generic data source provider");
            return;
        }
        DriverDescriptor sqliteDriver = genericDSProvider.getDriver("sqlite_jdbc");
        if (sqliteDriver == null) {
            log.error((Object)"Can't find SQLite driver is generic provider");
            return;
        }
        File dbFolder = new File(GeneralUtils.getMetadataFolder(), SAMPLE_DB1_FOLDER);
        if (!dbFolder.exists() && !dbFolder.mkdirs()) {
            log.error((Object)("Can't create target database folder " + dbFolder.getAbsolutePath()));
            return;
        }
        File dbFile = new File(dbFolder, SAMPLE_DB_FILE_NAME);
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(SAMPLE_DB_SOURCE_PATH);){
                Throwable throwable2 = null;
                Object var12_16 = null;
                try (FileOutputStream os = new FileOutputStream(dbFile);){
                    IOUtils.copyStream((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)"Error extracting sample database to workspace", (Throwable)e);
            return;
        }
        DBPConnectionConfiguration connectionInfo = new DBPConnectionConfiguration();
        connectionInfo.setDatabaseName(dbFile.getAbsolutePath());
        connectionInfo.setConnectionType(DBPConnectionType.DEV);
        connectionInfo.setUrl(genericDSProvider.getInstance(sqliteDriver).getConnectionURL((DBPDriver)sqliteDriver, connectionInfo));
        dataSource = new DataSourceDescriptor(dsRegistry, SAMPLE_DB1_ID, sqliteDriver, connectionInfo);
        ((DataSourceDescriptor)dataSource).setSavePassword(true);
        ((DataSourceDescriptor)dataSource).setShowSystemObjects(true);
        dataSource.setName("DBeaver Sample Database (SQLite)");
        dsRegistry.addDataSource(dataSource);
    }
}

