/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.eval;

import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.eval.ScriptVariablesContext;

public class ScriptEvaluateEngine {
    private final SQLScriptContext scriptContext;
    private final JexlEngine jexlEngine;
    private final ScriptVariablesContext variablesContext;

    private ScriptEvaluateEngine(SQLScriptContext scriptContext) {
        this.scriptContext = scriptContext;
        this.jexlEngine = new JexlEngine(null, null, null, null);
        this.jexlEngine.setCache(100);
        this.variablesContext = new ScriptVariablesContext(scriptContext);
    }

    public Object evaluateExpression(String exprString) throws DBException {
        try {
            Expression expression = this.jexlEngine.createExpression(exprString);
            return expression.evaluate((JexlContext)this.variablesContext);
        }
        catch (Exception e) {
            throw new DBException("Error evaluating expression [" + exprString + "]", e);
        }
    }

    public static ScriptEvaluateEngine getEngine(SQLScriptContext scriptContext) {
        ScriptEvaluateEngine engine = (ScriptEvaluateEngine)scriptContext.getData("evalEngine");
        if (engine == null) {
            engine = new ScriptEvaluateEngine(scriptContext);
            scriptContext.setData("evalEngine", engine);
        }
        return engine;
    }
}

