/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.impl.data.formatters.BinaryFormatterHexNative;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLStateType;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class BasicSQLDialect
implements SQLDialect {
    private static final String[] DEFAULT_LINE_COMMENTS = new String[]{"--"};
    private static final String[] EXEC_KEYWORDS = new String[0];
    private static final String[] DDL_KEYWORDS = new String[]{"CREATE", "ALTER", "DROP"};
    private static final String[][] DEFAULT_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}};
    protected static final String[] NON_TRANSACTIONAL_KEYWORDS = new String[]{"EXPLAIN", "DESCRIBE", "DESC", "USE", "SET", "COMMIT", "ROLLBACK"};
    private static final String[] CORE_NON_TRANSACTIONAL_KEYWORDS = new String[]{"SELECT"};
    public static final String[][] DEFAULT_QUOTE_STRINGS = new String[][]{{"\"", "\""}};
    private TreeMap<String, DBPKeywordType> allKeywords = new TreeMap();
    private final TreeSet<String> reservedWords = new TreeSet();
    private final TreeSet<String> functions = new TreeSet();
    protected final TreeSet<String> types = new TreeSet();
    protected final TreeSet<String> tableQueryWords = new TreeSet();
    private final TreeSet<String> columnQueryWords = new TreeSet();
    private Pair<String, String> multiLineComments = new Pair((Object)"/*", (Object)"*/");
    public static final BasicSQLDialect INSTANCE = new BasicSQLDialect();

    protected BasicSQLDialect() {
        this.loadStandardKeywords();
    }

    @Override
    @NotNull
    public String getDialectName() {
        return "SQL";
    }

    @Override
    @Nullable
    public String[][] getIdentifierQuoteStrings() {
        return DEFAULT_QUOTE_STRINGS;
    }

    @Override
    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    @Override
    @NotNull
    public String[] getDDLKeywords() {
        return DDL_KEYWORDS;
    }

    protected void addSQLKeyword(String keyword) {
        this.reservedWords.add(keyword);
        this.allKeywords.put(keyword, DBPKeywordType.KEYWORD);
    }

    protected void removeSQLKeyword(String keyword) {
        this.reservedWords.remove(keyword);
        this.allKeywords.remove(keyword);
    }

    protected void addSQLKeywords(Collection<String> allKeywords) {
        for (String kw : allKeywords) {
            this.addSQLKeyword(kw);
        }
    }

    protected void addFunctions(Collection<String> allFunctions) {
        this.functions.addAll(allFunctions);
        this.addKeywords(allFunctions, DBPKeywordType.FUNCTION);
    }

    protected void addDataTypes(Collection<String> allTypes) {
        for (String type : allTypes) {
            this.types.add(type.toUpperCase(Locale.ENGLISH));
        }
        this.addKeywords(allTypes, DBPKeywordType.TYPE);
    }

    protected void addKeywords(Collection<String> set, DBPKeywordType type) {
        if (set != null) {
            for (String keyword : set) {
                keyword = keyword.toUpperCase(Locale.ENGLISH);
                this.reservedWords.add(keyword);
                DBPKeywordType oldType = this.allKeywords.get(keyword);
                if (oldType == DBPKeywordType.KEYWORD) continue;
                this.allKeywords.put(keyword, type);
            }
        }
    }

    @Override
    @NotNull
    public Set<String> getReservedWords() {
        return this.reservedWords;
    }

    @Override
    @NotNull
    public Set<String> getFunctions(@NotNull DBPDataSource dataSource) {
        return this.functions;
    }

    @NotNull
    public TreeSet<String> getDataTypes(@NotNull DBPDataSource dataSource) {
        return this.types;
    }

    @Override
    public DBPKeywordType getKeywordType(@NotNull String word) {
        return this.allKeywords.get(word.toUpperCase(Locale.ENGLISH));
    }

    @Override
    @NotNull
    public List<String> getMatchedKeywords(@NotNull String word) {
        word = word.toUpperCase(Locale.ENGLISH);
        ArrayList<String> result = new ArrayList<String>();
        for (String keyword : this.allKeywords.tailMap(word).keySet()) {
            if (!keyword.startsWith(word)) break;
            result.add(keyword);
        }
        return result;
    }

    @Override
    public boolean isKeywordStart(@NotNull String word) {
        SortedMap<String, DBPKeywordType> map = this.allKeywords.tailMap(word.toUpperCase(Locale.ENGLISH));
        return !map.isEmpty() && map.firstKey().startsWith(word);
    }

    @Override
    public boolean isEntityQueryWord(@NotNull String word) {
        return this.tableQueryWords.contains(word.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public boolean isAttributeQueryWord(@NotNull String word) {
        return this.columnQueryWords.contains(word.toUpperCase(Locale.ENGLISH));
    }

    @Override
    @NotNull
    public String getSearchStringEscape() {
        return null;
    }

    @Override
    public char getStringEscapeCharacter() {
        return '\u0000';
    }

    @Override
    public int getCatalogUsage() {
        return 0;
    }

    @Override
    public int getSchemaUsage() {
        return 0;
    }

    @Override
    @NotNull
    public String getCatalogSeparator() {
        return String.valueOf('.');
    }

    @Override
    public char getStructSeparator() {
        return '.';
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    @NotNull
    public SQLStateType getSQLStateType() {
        return SQLStateType.SQL99;
    }

    @Override
    @NotNull
    public String getScriptDelimiter() {
        return ";";
    }

    @Override
    @Nullable
    public String getScriptDelimiterRedefiner() {
        return null;
    }

    @Override
    public String[][] getBlockBoundStrings() {
        return DEFAULT_BEGIN_END_BLOCK;
    }

    @Override
    @Nullable
    public String[] getBlockHeaderStrings() {
        return null;
    }

    @Override
    @Nullable
    public String getBlockToggleString() {
        return null;
    }

    @Override
    public boolean validIdentifierStart(char c) {
        return Character.isLetter(c);
    }

    @Override
    public boolean validIdentifierPart(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    @Override
    public boolean supportsUnquotedMixedCase() {
        return true;
    }

    @Override
    public boolean supportsQuotedMixedCase() {
        return true;
    }

    @Override
    @NotNull
    public DBPIdentifierCase storesUnquotedCase() {
        return DBPIdentifierCase.UPPER;
    }

    @Override
    @NotNull
    public DBPIdentifierCase storesQuotedCase() {
        return DBPIdentifierCase.MIXED;
    }

    @Override
    @NotNull
    public String escapeString(String string) {
        return string.replace("'", "''");
    }

    @Override
    @NotNull
    public String unEscapeString(String string) {
        return CommonUtils.notEmpty((String)string).replace("''", "'");
    }

    @Override
    @NotNull
    public String escapeScriptValue(DBSAttributeBase attribute, @NotNull Object value, @NotNull String strValue) {
        if (value instanceof UUID) {
            return String.valueOf('\'') + this.escapeString(strValue) + '\'';
        }
        return strValue;
    }

    @Override
    @NotNull
    public SQLDialect.MultiValueInsertMode getMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.NOT_SUPPORTED;
    }

    @Override
    public String addFiltersToQuery(DBPDataSource dataSource, String query, DBDDataFilter filter) {
        return SQLSemanticProcessor.addFiltersToQuery(dataSource, query, filter);
    }

    @Override
    public boolean supportsSubqueries() {
        return true;
    }

    @Override
    public boolean supportsAliasInSelect() {
        return false;
    }

    @Override
    public boolean supportsAliasInUpdate() {
        return false;
    }

    @Override
    public boolean supportsTableDropCascade() {
        return false;
    }

    @Override
    public boolean supportsOrderByIndex() {
        return true;
    }

    @Override
    public boolean supportsCommentQuery() {
        return false;
    }

    @Override
    public boolean supportsNullability() {
        return true;
    }

    @Override
    public Pair<String, String> getMultiLineComments() {
        return this.multiLineComments;
    }

    @Override
    public String[] getSingleLineComments() {
        return DEFAULT_LINE_COMMENTS;
    }

    @Override
    public boolean isDelimiterAfterQuery() {
        return false;
    }

    @Override
    public boolean isDelimiterAfterBlock() {
        return false;
    }

    @Override
    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter() {
        return BinaryFormatterHexNative.INSTANCE;
    }

    @Override
    public String getTestSQL() {
        return null;
    }

    @Override
    @Nullable
    public String getDualTableName() {
        return null;
    }

    @Override
    public boolean isTransactionModifyingQuery(String queryString) {
        if ((queryString = SQLUtils.stripComments(this, queryString.toUpperCase(Locale.ENGLISH)).trim()).isEmpty()) {
            return false;
        }
        String[] ntk = this.getNonTransactionKeywords();
        int i = 0;
        while (i < ntk.length) {
            if (queryString.startsWith(ntk[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @NotNull
    protected String[] getNonTransactionKeywords() {
        return this.isStandardSQL() ? NON_TRANSACTIONAL_KEYWORDS : CORE_NON_TRANSACTIONAL_KEYWORDS;
    }

    @Override
    public boolean isQuoteReservedWords() {
        return true;
    }

    @Override
    public boolean isCRLFBroken() {
        return false;
    }

    protected boolean isStandardSQL() {
        return true;
    }

    private void loadStandardKeywords() {
        HashSet<String> all = new HashSet<String>();
        if (this.isStandardSQL()) {
            Collections.addAll(all, SQLConstants.SQL2003_RESERVED_KEYWORDS);
            Collections.addAll(all, SQLConstants.SQL_EX_KEYWORDS);
            Collections.addAll(this.functions, SQLConstants.SQL2003_FUNCTIONS);
            Collections.addAll(this.tableQueryWords, SQLConstants.TABLE_KEYWORDS);
            Collections.addAll(this.columnQueryWords, SQLConstants.COLUMN_KEYWORDS);
        }
        for (String executeKeyword : ArrayUtils.safeArray((Object[])this.getExecuteKeywords())) {
            this.addSQLKeyword(executeKeyword);
        }
        for (String ddlKeyword : ArrayUtils.safeArray((Object[])this.getDDLKeywords())) {
            this.addSQLKeyword(ddlKeyword);
        }
        if (this.isStandardSQL()) {
            Collections.addAll(this.types, SQLConstants.DEFAULT_TYPES);
            this.addKeywords(all, DBPKeywordType.KEYWORD);
            this.addKeywords(this.types, DBPKeywordType.TYPE);
            this.addKeywords(this.functions, DBPKeywordType.FUNCTION);
        }
    }

    @Override
    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        DBSDataType dataType;
        typeName = CommonUtils.notEmpty((String)typeName).toUpperCase(Locale.ENGLISH);
        if (column instanceof DBSObject && (dataType = DBUtils.getLocalDataType(((DBSObject)((Object)column)).getDataSource(), column.getTypeName())) != null && CommonUtils.equalObjects((Object)dataType.getScale(), (Object)column.getScale()) && (CommonUtils.toInt((Object)dataType.getPrecision()) > 0 && CommonUtils.equalObjects((Object)dataType.getPrecision(), (Object)column.getPrecision()) || dataType.getMaxLength() > 0L && dataType.getMaxLength() == column.getMaxLength())) {
            return null;
        }
        if (dataKind == DBPDataKind.STRING) {
            long maxLength;
            if (typeName.indexOf(40) == -1 && (maxLength = column.getMaxLength()) > 0L) {
                Object maxStringLength = dataSource.getDataSourceFeature("datasource.max-string-type-length");
                if (maxStringLength instanceof Number) {
                    int lengthLimit = ((Number)maxStringLength).intValue();
                    if (lengthLimit < 0) {
                        return null;
                    }
                    if ((long)lengthLimit < maxLength) {
                        maxLength = lengthLimit;
                    }
                }
                return "(" + maxLength + ")";
            }
        } else if (!(dataKind != DBPDataKind.CONTENT && dataKind != DBPDataKind.BINARY || typeName.contains("LOB"))) {
            long maxLength = column.getMaxLength();
            if (maxLength > 0L && maxLength < Integer.MAX_VALUE) {
                return "(" + maxLength + ')';
            }
        } else if (dataKind == DBPDataKind.NUMERIC) {
            int precision;
            if (typeName.equals("DECIMAL") || typeName.equals("NUMERIC") || typeName.equals("NUMBER")) {
                Integer scale = column.getScale();
                int precision2 = CommonUtils.toInt((Object)column.getPrecision());
                if (precision2 == 0) {
                    precision2 = (int)column.getMaxLength();
                }
                if (scale != null && scale >= 0 && precision2 >= 0 && (scale != 0 || precision2 != 0)) {
                    return "(" + precision2 + ',' + scale + ')';
                }
            } else if (typeName.equals("BIT") && (precision = CommonUtils.toInt((Object)column.getPrecision())) > 1) {
                return "(" + precision + ')';
            }
        }
        return null;
    }

    @Override
    public String formatStoredProcedureCall(DBPDataSource dataSource, String sqlText) {
        return sqlText;
    }

    protected int getMaxParameterLength(Collection<? extends DBSProcedureParameter> parameters, List<DBSProcedureParameter> inParameters) {
        int maxParamLength = 0;
        for (DBSProcedureParameter dBSProcedureParameter : parameters) {
            if (dBSProcedureParameter.getParameterKind() != DBSProcedureParameterKind.IN) continue;
            inParameters.add(dBSProcedureParameter);
            if (dBSProcedureParameter.getName().length() <= maxParamLength) continue;
            maxParamLength = dBSProcedureParameter.getName().length();
        }
        return maxParamLength;
    }

    protected boolean useBracketsForExec() {
        return false;
    }

    protected String getStoredProcedureCallInitialClause(DBSProcedure proc) {
        Object[] executeKeywords = this.getExecuteKeywords();
        if (proc.getProcedureType() == DBSProcedureType.FUNCTION || ArrayUtils.isEmpty((Object[])executeKeywords)) {
            return "SELECT " + proc.getFullyQualifiedName(DBPEvaluationContext.DML);
        }
        return String.valueOf(executeKeywords[0]) + " " + proc.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    @Override
    public void generateStoredProcedureCall(StringBuilder sql, DBSProcedure proc, Collection<? extends DBSProcedureParameter> parameters) {
        ArrayList<DBSProcedureParameter> inParameters = new ArrayList<DBSProcedureParameter>();
        this.getMaxParameterLength(parameters, inParameters);
        boolean useBrackets = this.useBracketsForExec();
        if (useBrackets) {
            sql.append("{ ");
        }
        sql.append(this.getStoredProcedureCallInitialClause(proc)).append("(");
        if (!inParameters.isEmpty()) {
            sql.append("\n");
            int i = 0;
            while (i < inParameters.size()) {
                DBSProcedureParameter parameter = (DBSProcedureParameter)inParameters.get(i);
                sql.append("\t:").append(CommonUtils.escapeIdentifier((String)parameter.getName()));
                if (i < inParameters.size() - 1) {
                    sql.append(",");
                } else {
                    sql.append(" ");
                }
                String typeName = parameter.getParameterType().getFullTypeName();
                sql.append("\t-- put the ").append(parameter.getName()).append(" parameter value instead of '").append(parameter.getName()).append("' (").append(typeName).append(")\n");
                ++i;
            }
        }
        sql.append(")");
        if (!useBrackets) {
            sql.append(";");
        } else {
            sql.append(" }");
        }
        sql.append("\n\n");
    }

    @Override
    public boolean isDisableScriptEscapeProcessing() {
        return false;
    }
}

