/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.io.FileNotFoundException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.transfer.MetadataNotFoundException;

class LoggingRepositoryListener
extends AbstractRepositoryListener {
    private final Logger logger;

    public LoggingRepositoryListener(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void artifactInstalling(RepositoryEvent event) {
        this.logger.info("Installing " + event.getArtifact().getFile() + " to " + event.getFile());
    }

    @Override
    public void metadataInstalling(RepositoryEvent event) {
        this.logger.debug("Installing " + event.getMetadata() + " to " + event.getFile());
    }

    @Override
    public void metadataResolved(RepositoryEvent event) {
        Exception e2 = event.getException();
        if (e2 != null) {
            if (e2 instanceof MetadataNotFoundException) {
                this.logger.debug(e2.getMessage());
            } else if (this.logger.isDebugEnabled()) {
                this.logger.warn(e2.getMessage(), e2);
            } else {
                this.logger.warn(e2.getMessage());
            }
        }
    }

    @Override
    public void metadataInvalid(RepositoryEvent event) {
        Exception exception = event.getException();
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("The metadata ");
        if (event.getMetadata().getFile() != null) {
            buffer.append(event.getMetadata().getFile());
        } else {
            buffer.append(event.getMetadata());
        }
        if (exception instanceof FileNotFoundException) {
            buffer.append(" is inaccessible");
        } else {
            buffer.append(" is invalid");
        }
        if (exception != null) {
            buffer.append(": ");
            buffer.append(exception.getMessage());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(buffer.toString(), exception);
        } else {
            this.logger.warn(buffer.toString());
        }
    }

    @Override
    public void artifactDescriptorInvalid(RepositoryEvent event) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("The POM for ");
        buffer.append(event.getArtifact());
        buffer.append(" is invalid, transitive dependencies (if any) will not be available");
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(buffer + ": " + event.getException().getMessage());
        } else {
            this.logger.warn(buffer + ", enable debug logging for more details");
        }
    }

    @Override
    public void artifactDescriptorMissing(RepositoryEvent event) {
        this.logger.warn("The POM for " + event.getArtifact() + " is missing, no dependency information available");
    }
}

