/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;
import javax.lang.model.type.TypeKind;

@BugPattern(name="IntLongMath", summary="Expression of type int may overflow before being assigned to a long", severity=BugPattern.SeverityLevel.WARNING, category=BugPattern.Category.JDK, tags={"FragileCode"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class IntLongMath
extends BugChecker
implements BugChecker.VariableTreeMatcher,
BugChecker.AssignmentTreeMatcher,
BugChecker.ReturnTreeMatcher {
    public Description matchReturn(ReturnTree tree, VisitorState state) {
        if (tree.getExpression() == null) {
            return Description.NO_MATCH;
        }
        Type type = null;
        block4: for (Tree parent : state.getPath()) {
            switch (parent.getKind()) {
                case METHOD: {
                    type = ASTHelpers.getType((Tree)((MethodTree)parent).getReturnType());
                    break block4;
                }
                case LAMBDA_EXPRESSION: {
                    type = state.getTypes().findDescriptorType(ASTHelpers.getType((Tree)parent)).getReturnType();
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (type == null) {
            return Description.NO_MATCH;
        }
        return this.check(type, tree.getExpression());
    }

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        return this.check(ASTHelpers.getType((Tree)tree), tree.getExpression());
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.check(ASTHelpers.getType((Tree)tree), tree.getInitializer());
    }

    Description check(Type targetType, ExpressionTree init) {
        if (init == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.constValue((Tree)init) != null) {
            return Description.NO_MATCH;
        }
        if (targetType.getKind() != TypeKind.LONG) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.getType((Tree)init).getKind() != TypeKind.INT) {
            return Description.NO_MATCH;
        }
        BinaryTree innerMost = null;
        ExpressionTree nested = init;
        while ((nested = ASTHelpers.stripParentheses((ExpressionTree)nested)) instanceof BinaryTree) {
            switch (nested.getKind()) {
                case DIVIDE: 
                case REMAINDER: 
                case AND: 
                case XOR: 
                case OR: 
                case RIGHT_SHIFT: {
                    break;
                }
                default: {
                    innerMost = (BinaryTree)nested;
                }
            }
            nested = ((BinaryTree)nested).getLeftOperand();
        }
        if (innerMost == null) {
            return Description.NO_MATCH;
        }
        if (innerMost.getLeftOperand().getKind() == Tree.Kind.INT_LITERAL) {
            return this.describeMatch(init, (Fix)SuggestedFix.postfixWith((Tree)innerMost.getLeftOperand(), (String)"L"));
        }
        if (innerMost.getRightOperand().getKind() == Tree.Kind.INT_LITERAL) {
            return this.describeMatch(init, (Fix)SuggestedFix.postfixWith((Tree)innerMost.getRightOperand(), (String)"L"));
        }
        return this.describeMatch(init, (Fix)SuggestedFix.prefixWith((Tree)innerMost.getLeftOperand(), (String)"(long) "));
    }
}

