/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */

'use strict';

var _extends3 = _interopRequireDefault(require('babel-runtime/helpers/extends'));

var _classCallCheck3 = _interopRequireDefault(require('babel-runtime/helpers/classCallCheck'));

var _possibleConstructorReturn3 = _interopRequireDefault(require('babel-runtime/helpers/possibleConstructorReturn'));

var _inherits3 = _interopRequireDefault(require('babel-runtime/helpers/inherits'));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * Decorates a component and injects Relay context as a prop.
 * This allows it to be used in the static getDerivedStateFromProps lifecycle.
 */
function injectContext(Component) {
  // TODO (T25783053) Update this container to use the new React context API,
  // Once we have confirmed that it's okay to raise min React version to 16.3.
  var ReactRelayContextConsumer = function (_React$Component) {
    (0, _inherits3['default'])(ReactRelayContextConsumer, _React$Component);

    function ReactRelayContextConsumer() {
      (0, _classCallCheck3['default'])(this, ReactRelayContextConsumer);
      return (0, _possibleConstructorReturn3['default'])(this, _React$Component.apply(this, arguments));
    }

    ReactRelayContextConsumer.prototype.render = function render() {
      return require('react').createElement(Component, (0, _extends3['default'])({}, this.props, { relay: this.context.relay }));
    };

    return ReactRelayContextConsumer;
  }(require('react').Component);

  ReactRelayContextConsumer.contextTypes = {
    relay: require('./RelayPropTypes').Relay
  };


  return ReactRelayContextConsumer;
}

module.exports = { injectContext: injectContext };