'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareCommitView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareCommitView extends _react2.default.Component {
  constructor(...args) {
    var _temp;

    return _temp = super(...args), this.openCommitDetailItem = () => this.props.openCommit({ sha: this.props.commit.sha }), _temp;
  }

  authoredByCommitter(commit) {
    if (commit.authoredByCommitter) {
      return true;
    }
    // If you commit on GitHub online the committer details would be:
    //
    //    name: "GitHub"
    //    email: "noreply@github.com"
    //    user: null
    //
    if (commit.committer.email === 'noreply@github.com') {
      return true;
    }
    if (commit.committer.name === 'GitHub' && commit.committer.user === null) {
      return true;
    }

    return false;
  }

  renderCommitter(commit) {
    if (!this.authoredByCommitter(commit)) {
      return _react2.default.createElement('img', {
        className: 'author-avatar', alt: 'author\'s avatar', src: commit.committer.avatarUrl,
        title: commit.committer.user ? commit.committer.user.login : commit.committer.name
      });
    } else {
      return null;
    }
  }

  render() {
    const commit = this.props.commit;
    return _react2.default.createElement(
      'div',
      { className: 'commit' },
      _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'git-commit' }),
      _react2.default.createElement(
        'span',
        { className: 'commit-author' },
        _react2.default.createElement('img', {
          className: 'author-avatar', alt: 'author\'s avatar', src: commit.author.avatarUrl,
          title: commit.author.user ? commit.author.user.login : commit.author.name
        }),
        this.renderCommitter(commit)
      ),
      _react2.default.createElement(
        'p',
        { className: 'commit-message-headline' },
        this.props.onBranch ? _react2.default.createElement('button', {
          className: 'open-commit-detail-button',
          title: commit.message,
          dangerouslySetInnerHTML: { __html: commit.messageHeadlineHTML },
          onClick: this.openCommitDetailItem
        }) : _react2.default.createElement('span', {
          title: commit.message,
          dangerouslySetInnerHTML: { __html: commit.messageHeadlineHTML }
        })
      ),
      _react2.default.createElement(
        'a',
        { className: 'commit-sha', href: commit.commitUrl },
        commit.sha.slice(0, 8)
      )
    );
  }
}

exports.BareCommitView = BareCommitView;
BareCommitView.propTypes = {
  commit: _propTypes2.default.object.isRequired,
  onBranch: _propTypes2.default.bool.isRequired,
  openCommit: _propTypes2.default.func.isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(BareCommitView, {
  commit: function () {
    const node = require('./__generated__/commitView_commit.graphql');

    if (node.hash && node.hash !== '9d2823ee95f39173f656043ddfc8d47c') {
      console.error('The definition of \'commitView_commit\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/commitView_commit.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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