'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

_moment2.default.defineLocale('en-shortdiff', {
  parentLocale: 'en',
  relativeTime: {
    future: 'in %s',
    past: '%s ago',
    s: 'Now',
    ss: '<1m',
    m: '1m',
    mm: '%dm',
    h: '1h',
    hh: '%dh',
    d: '1d',
    dd: '%dd',
    M: '1M',
    MM: '%dM',
    y: '1y',
    yy: '%dy'
  }
});
_moment2.default.locale('en');

class Timeago extends _react2.default.Component {

  static getTimeDisplay(time, now, style) {
    const m = (0, _moment2.default)(time);
    if (style === 'short') {
      m.locale('en-shortdiff');
      return m.from(now, true);
    } else {
      const diff = m.diff(now, 'months', true);
      if (Math.abs(diff) <= 1) {
        m.locale('en');
        return m.from(now);
      } else {
        const format = m.format('MMM Do, YYYY');
        return `on ${format}`;
      }
    }
  }

  componentDidMount() {
    this.timer = setInterval(() => this.forceUpdate(), 60000);
  }

  componentWillUnmount() {
    clearInterval(this.timer);
  }

  render() {
    const _props = this.props,
          { type, time, displayStyle } = _props,
          others = _objectWithoutProperties(_props, ['type', 'time', 'displayStyle']);
    const display = Timeago.getTimeDisplay(time, (0, _moment2.default)(), displayStyle);
    const Type = type;
    const className = (0, _classnames2.default)('timeago', others.className);
    return _react2.default.createElement(
      Type,
      _extends({}, others, { className: className }),
      display
    );
  }
}
exports.default = Timeago;
Timeago.propTypes = {
  time: _propTypes2.default.any.isRequired,
  type: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func]),
  displayStyle: _propTypes2.default.oneOf(['short', 'long'])
};
Timeago.defaultProps = {
  type: 'span',
  displayStyle: 'long'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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