'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BarePullRequestDetailView = exports.checkoutStates = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _reactTabs = require('react-tabs');

var _propTypes3 = require('../prop-types');

var _reporterProxy = require('../reporter-proxy');

var _periodicRefresher = require('../periodic-refresher');

var _periodicRefresher2 = _interopRequireDefault(_periodicRefresher);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _prChangedFilesContainer = require('../containers/pr-changed-files-container');

var _prChangedFilesContainer2 = _interopRequireDefault(_prChangedFilesContainer);

var _prTimelineController = require('../controllers/pr-timeline-controller');

var _prTimelineController2 = _interopRequireDefault(_prTimelineController);

var _githubDotcomMarkdown = require('../views/github-dotcom-markdown');

var _githubDotcomMarkdown2 = _interopRequireDefault(_githubDotcomMarkdown);

var _emojiReactionsView = require('../views/emoji-reactions-view');

var _emojiReactionsView2 = _interopRequireDefault(_emojiReactionsView);

var _issueishBadge = require('../views/issueish-badge');

var _issueishBadge2 = _interopRequireDefault(_issueishBadge);

var _prCommitsView = require('../views/pr-commits-view');

var _prCommitsView2 = _interopRequireDefault(_prCommitsView);

var _prStatusesView = require('../views/pr-statuses-view');

var _prStatusesView2 = _interopRequireDefault(_prStatusesView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CheckoutState {
  constructor(name) {
    this.name = name;
  }

  when(cases) {
    return cases[this.name] || cases.default;
  }
}

const checkoutStates = exports.checkoutStates = {
  HIDDEN: new CheckoutState('hidden'),
  DISABLED: new CheckoutState('disabled'),
  BUSY: new CheckoutState('busy'),
  CURRENT: new CheckoutState('current')
};

class BarePullRequestDetailView extends _react2.default.Component {
  constructor(...args) {
    var _temp;

    return _temp = super(...args), this.state = {
      refreshing: false
    }, this.handleRefreshClick = e => {
      e.preventDefault();
      this.refresher.refreshNow(true);
    }, this.recordOpenInBrowserEvent = () => {
      (0, _reporterProxy.addEvent)('open-pull-request-in-browser', { package: 'github', component: this.constructor.name });
    }, this.recordOpenTabEvent = ind => {
      const eventName = ['open-pr-tab-overview', 'open-pr-tab-build-status', 'open-pr-tab-commits', 'open-pr-tab-files-changed'][ind];
      (0, _reporterProxy.addEvent)(eventName, { package: 'github', component: this.constructor.name });
    }, this.refresh = () => {
      if (this.state.refreshing) {
        return;
      }

      this.setState({ refreshing: true });
      this.props.relay.refetch({
        repoId: this.props.repository.id,
        issueishId: this.props.pullRequest.id,
        timelineCount: 100,
        timelineCursor: null,
        commitCount: 100,
        commitCursor: null
      }, null, () => {
        this.setState({ refreshing: false });
      }, { force: true });
    }, _temp;
  }

  componentDidMount() {
    this.refresher = new _periodicRefresher2.default(BarePullRequestDetailView, {
      interval: () => 5 * 60 * 1000,
      getCurrentId: () => this.props.pullRequest.id,
      refresh: this.refresh,
      minimumIntervalPerId: 2 * 60 * 1000
    });
    // auto-refresh disabled for now until pagination is handled
    // this.refresher.start();
  }

  componentWillUnmount() {
    this.refresher.destroy();
  }

  renderPrMetadata(pullRequest, repo) {
    return _react2.default.createElement(
      'span',
      { className: 'github-IssueishDetailView-meta' },
      _react2.default.createElement(
        'code',
        { className: 'github-IssueishDetailView-baseRefName' },
        pullRequest.isCrossRepository ? `${repo.owner.login}/${pullRequest.baseRefName}` : pullRequest.baseRefName
      ),
      ' ‹ ',
      _react2.default.createElement(
        'code',
        { className: 'github-IssueishDetailView-headRefName' },
        pullRequest.isCrossRepository ? `${pullRequest.author.login}/${pullRequest.headRefName}` : pullRequest.headRefName
      )
    );
  }

  renderPullRequestBody(pullRequest) {
    const onBranch = this.props.checkoutOp.why() === checkoutStates.CURRENT;

    return _react2.default.createElement(
      _reactTabs.Tabs,
      { onSelect: this.recordOpenTabEvent },
      _react2.default.createElement(
        _reactTabs.TabList,
        { className: 'github-IssueishDetailView-tablist' },
        _react2.default.createElement(
          _reactTabs.Tab,
          { className: 'github-IssueishDetailView-tab' },
          _react2.default.createElement(_octicon2.default, { icon: 'info', className: 'github-IssueishDetailView-tab-icon' }),
          'Overview'
        ),
        _react2.default.createElement(
          _reactTabs.Tab,
          { className: 'github-IssueishDetailView-tab' },
          _react2.default.createElement(_octicon2.default, { icon: 'checklist', className: 'github-IssueishDetailView-tab-icon' }),
          'Build Status'
        ),
        _react2.default.createElement(
          _reactTabs.Tab,
          { className: 'github-IssueishDetailView-tab' },
          _react2.default.createElement(_octicon2.default, { icon: 'git-commit',
            className: 'github-IssueishDetailView-tab-icon'
          }),
          'Commits',
          _react2.default.createElement(
            'span',
            { className: 'github-IssueishDetailView-tab-count' },
            pullRequest.countedCommits.totalCount
          )
        ),
        _react2.default.createElement(
          _reactTabs.Tab,
          { className: 'github-IssueishDetailView-tab' },
          _react2.default.createElement(_octicon2.default, { icon: 'diff',
            className: 'github-IssueishDetailView-tab-icon'
          }),
          'Files',
          _react2.default.createElement(
            'span',
            { className: 'github-IssueishDetailView-tab-count' },
            pullRequest.changedFiles
          )
        )
      ),
      _react2.default.createElement(
        _reactTabs.TabPanel,
        null,
        _react2.default.createElement(
          'div',
          { className: 'github-IssueishDetailView-overview' },
          _react2.default.createElement(_githubDotcomMarkdown2.default, {
            html: pullRequest.bodyHTML || '<em>No description provided.</em>',
            switchToIssueish: this.props.switchToIssueish
          }),
          _react2.default.createElement(_emojiReactionsView2.default, { reactionGroups: pullRequest.reactionGroups }),
          _react2.default.createElement(_prTimelineController2.default, {
            onBranch: onBranch,
            openCommit: this.props.openCommit,
            pullRequest: pullRequest,
            switchToIssueish: this.props.switchToIssueish
          })
        )
      ),
      _react2.default.createElement(
        _reactTabs.TabPanel,
        null,
        _react2.default.createElement(
          'div',
          { className: 'github-IssueishDetailView-buildStatus' },
          _react2.default.createElement(_prStatusesView2.default, { pullRequest: pullRequest, displayType: 'full' })
        )
      ),
      _react2.default.createElement(
        _reactTabs.TabPanel,
        null,
        _react2.default.createElement(_prCommitsView2.default, { pullRequest: pullRequest, onBranch: onBranch, openCommit: this.props.openCommit })
      ),
      _react2.default.createElement(
        _reactTabs.TabPanel,
        { className: 'github-IssueishDetailView-filesChanged' },
        _react2.default.createElement(_prChangedFilesContainer2.default, {
          localRepository: this.props.localRepository,

          owner: this.props.repository.owner.login,
          repo: this.props.repository.name,
          number: pullRequest.number,

          endpoint: this.props.endpoint,
          token: this.props.token,

          workspace: this.props.workspace,
          commands: this.props.commands,
          keymaps: this.props.keymaps,
          tooltips: this.props.tooltips,
          config: this.props.config,

          itemType: this.props.itemType,
          destroy: this.props.destroy,

          shouldRefetch: this.state.refreshing
        })
      )
    );
  }

  render() {
    const repo = this.props.repository;
    const pullRequest = this.props.pullRequest;

    return _react2.default.createElement(
      'div',
      { className: 'github-IssueishDetailView native-key-bindings' },
      _react2.default.createElement(
        'div',
        { className: 'github-IssueishDetailView-container' },
        _react2.default.createElement(
          'header',
          { className: 'github-IssueishDetailView-header' },
          _react2.default.createElement(
            'div',
            { className: 'github-IssueishDetailView-headerColumn' },
            _react2.default.createElement(
              'a',
              { className: 'github-IssueishDetailView-avatar', href: pullRequest.author.url },
              _react2.default.createElement('img', { className: 'github-IssueishDetailView-avatarImage',
                src: pullRequest.author.avatarUrl,
                title: pullRequest.author.login,
                alt: pullRequest.author.login
              })
            )
          ),
          _react2.default.createElement(
            'div',
            { className: 'github-IssueishDetailView-headerColumn is-flexible' },
            _react2.default.createElement(
              'div',
              { className: 'github-IssueishDetailView-headerRow is-fullwidth' },
              _react2.default.createElement(
                'a',
                { className: 'github-IssueishDetailView-title', href: pullRequest.url },
                pullRequest.title
              )
            ),
            _react2.default.createElement(
              'div',
              { className: 'github-IssueishDetailView-headerRow' },
              _react2.default.createElement(_issueishBadge2.default, { className: 'github-IssueishDetailView-headerBadge',
                type: pullRequest.__typename,
                state: pullRequest.state
              }),
              _react2.default.createElement(_octicon2.default, {
                icon: 'repo-sync',
                className: (0, _classnames2.default)('github-IssueishDetailView-headerRefreshButton', { refreshing: this.state.refreshing }),
                onClick: this.handleRefreshClick
              }),
              _react2.default.createElement(
                'a',
                { className: 'github-IssueishDetailView-headerLink',
                  title: 'open on GitHub.com',
                  href: pullRequest.url, onClick: this.recordOpenInBrowserEvent },
                repo.owner.login,
                '/',
                repo.name,
                '#',
                pullRequest.number
              ),
              _react2.default.createElement(
                'span',
                { className: 'github-IssueishDetailView-headerStatus' },
                _react2.default.createElement(_prStatusesView2.default, { pullRequest: pullRequest, displayType: 'check' })
              )
            ),
            _react2.default.createElement(
              'div',
              { className: 'github-IssueishDetailView-headerRow' },
              this.renderPrMetadata(pullRequest, repo)
            )
          ),
          _react2.default.createElement(
            'div',
            { className: 'github-IssueishDetailView-headerColumn' },
            this.renderCheckoutButton()
          )
        ),
        this.renderPullRequestBody(pullRequest),
        _react2.default.createElement(
          'footer',
          { className: 'github-IssueishDetailView-footer' },
          _react2.default.createElement(
            'a',
            { className: 'github-IssueishDetailView-footerLink icon icon-mark-github',
              href: pullRequest.url },
            repo.owner.login,
            '/',
            repo.name,
            '#',
            pullRequest.number
          )
        )
      )
    );
  }

  renderCheckoutButton() {
    const { checkoutOp } = this.props;
    let extraClass = null;
    let buttonText = 'Checkout';
    let buttonTitle = null;

    if (!checkoutOp.isEnabled()) {
      buttonTitle = checkoutOp.getMessage();
      const reason = checkoutOp.why();
      if (reason === checkoutStates.HIDDEN) {
        return null;
      }

      buttonText = reason.when({
        current: 'Checked out',
        default: 'Checkout'
      });

      extraClass = 'github-IssueishDetailView-checkoutButton--' + reason.when({
        disabled: 'disabled',
        busy: 'busy',
        current: 'current'
      });
    }

    const classNames = (0, _classnames2.default)('btn', 'btn-primary', 'github-IssueishDetailView-checkoutButton', extraClass);
    return _react2.default.createElement(
      'button',
      {
        className: classNames,
        disabled: !checkoutOp.isEnabled(),
        title: buttonTitle,
        onClick: () => checkoutOp.run() },
      buttonText
    );
  }

}

exports.BarePullRequestDetailView = BarePullRequestDetailView;
BarePullRequestDetailView.propTypes = {
  // Relay response
  relay: _propTypes2.default.shape({
    refetch: _propTypes2.default.func.isRequired
  }),
  switchToIssueish: _propTypes2.default.func.isRequired,
  checkoutOp: _propTypes3.EnableableOperationPropType.isRequired,
  repository: _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    name: _propTypes2.default.string.isRequired,
    owner: _propTypes2.default.shape({
      login: _propTypes2.default.string
    })
  }),
  pullRequest: _propTypes2.default.shape({
    __typename: _propTypes2.default.string.isRequired,
    id: _propTypes2.default.string.isRequired,
    title: _propTypes2.default.string,
    countedCommits: _propTypes2.default.shape({
      totalCount: _propTypes2.default.number.isRequired
    }).isRequired,
    isCrossRepository: _propTypes2.default.bool,
    changedFiles: _propTypes2.default.number.isRequired,
    url: _propTypes2.default.string.isRequired,
    bodyHTML: _propTypes2.default.string,
    number: _propTypes2.default.number,
    state: _propTypes2.default.oneOf(['OPEN', 'CLOSED', 'MERGED']).isRequired,
    author: _propTypes2.default.shape({
      login: _propTypes2.default.string.isRequired,
      avatarUrl: _propTypes2.default.string.isRequired,
      url: _propTypes2.default.string.isRequired
    }).isRequired,
    reactionGroups: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      content: _propTypes2.default.string.isRequired,
      users: _propTypes2.default.shape({
        totalCount: _propTypes2.default.number.isRequired
      }).isRequired
    })).isRequired
  }).isRequired,

  // Local model objects
  localRepository: _propTypes2.default.object.isRequired,

  // Connection information
  endpoint: _propTypes3.EndpointPropType.isRequired,
  token: _propTypes2.default.string.isRequired,

  // Atom environment
  workspace: _propTypes2.default.object.isRequired,
  commands: _propTypes2.default.object.isRequired,
  keymaps: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,

  // Action functions
  openCommit: _propTypes2.default.func.isRequired,
  destroy: _propTypes2.default.func.isRequired,

  // Item context
  itemType: _propTypes3.ItemTypePropType.isRequired
};
exports.default = (0, _reactRelay.createRefetchContainer)(BarePullRequestDetailView, {
  repository: function () {
    const node = require('./__generated__/prDetailView_repository.graphql');

    if (node.hash && node.hash !== '3f3d61ddd6afa1c9e0811c3b5be51bb0') {
      console.error('The definition of \'prDetailView_repository\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/prDetailView_repository.graphql');
  },

  pullRequest: function () {
    const node = require('./__generated__/prDetailView_pullRequest.graphql');

    if (node.hash && node.hash !== '2b7cc9778a3440738f809f76fcd3fd25') {
      console.error('The definition of \'prDetailView_pullRequest\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/prDetailView_pullRequest.graphql');
  }
}, function () {
  const node = require('./__generated__/prDetailViewRefetchQuery.graphql');

  if (node.hash && node.hash !== '04dad90234c09010553beb02cf90cbb1') {
    console.error('The definition of \'prDetailViewRefetchQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
  }

  return require('./__generated__/prDetailViewRefetchQuery.graphql');
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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