'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.collectionRenderer = collectionRenderer;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _propTypes3 = require('../prop-types');

var _helpers = require('../helpers');

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _commitsView = require('./timeline-items/commits-view.js');

var _commitsView2 = _interopRequireDefault(_commitsView);

var _issueCommentView = require('./timeline-items/issue-comment-view.js');

var _issueCommentView2 = _interopRequireDefault(_issueCommentView);

var _mergedEventView = require('./timeline-items/merged-event-view.js');

var _mergedEventView2 = _interopRequireDefault(_mergedEventView);

var _headRefForcePushedEventView = require('./timeline-items/head-ref-force-pushed-event-view.js');

var _headRefForcePushedEventView2 = _interopRequireDefault(_headRefForcePushedEventView);

var _crossReferencedEventsView = require('./timeline-items/cross-referenced-events-view.js');

var _crossReferencedEventsView2 = _interopRequireDefault(_crossReferencedEventsView);

var _commitCommentThreadView = require('./timeline-items/commit-comment-thread-view');

var _commitCommentThreadView2 = _interopRequireDefault(_commitCommentThreadView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function collectionRenderer(Component, styleAsTimelineItem = true) {
  var _class, _temp;

  return _temp = _class = class GroupedComponent extends _react2.default.Component {

    static getFragment(fragName, ...args) {
      const frag = fragName === 'nodes' ? 'item' : fragName;
      return Component.getFragment(frag, ...args);
    }

    constructor(props) {
      super(props);
      (0, _helpers.autobind)(this, 'renderNode');
    }

    render() {
      return _react2.default.createElement(
        'div',
        { className: styleAsTimelineItem ? 'timeline-item' : '' },
        this.props.nodes.map(this.renderNode)
      );
    }

    renderNode(node, i) {
      return _react2.default.createElement(Component, {
        key: i,
        item: node,
        issueish: this.props.issueish,
        switchToIssueish: this.props.switchToIssueish
      });
    }
  }, _class.displayName = `Grouped(${Component.displayName})`, _class.propTypes = {
    nodes: _propTypes2.default.array.isRequired,
    issueish: _propTypes2.default.object.isRequired,
    switchToIssueish: _propTypes2.default.func.isRequired
  }, _temp;
}

const timelineItems = {
  Commit: _commitsView2.default,
  CommitCommentThread: collectionRenderer(_commitCommentThreadView2.default, false),
  IssueComment: collectionRenderer(_issueCommentView2.default, false),
  MergedEvent: collectionRenderer(_mergedEventView2.default),
  HeadRefForcePushedEvent: collectionRenderer(_headRefForcePushedEventView2.default),
  CrossReferencedEvent: _crossReferencedEventsView2.default
};

const TimelineConnectionPropType = (0, _propTypes3.RelayConnectionPropType)(_propTypes2.default.shape({
  __typename: _propTypes2.default.string.isRequired
})).isRequired;

class IssueishTimelineView extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'loadMore');
  }

  loadMore() {
    this.props.relay.loadMore(10, () => {
      this.forceUpdate();
    });
    this.forceUpdate();
  }

  render() {
    const issueish = this.props.issue || this.props.pullRequest;
    const groupedEdges = this.groupEdges(issueish.timeline.edges);
    return _react2.default.createElement(
      'div',
      { className: 'github-PrTimeline' },
      groupedEdges.map(({ type, edges }) => {
        const Component = timelineItems[type];
        const propsForCommits = {
          onBranch: this.props.onBranch,
          openCommit: this.props.openCommit
        };
        if (Component) {
          return _react2.default.createElement(Component, _extends({
            key: `${type}-${edges[0].cursor}`,
            nodes: edges.map(e => e.node),
            issueish: issueish,
            switchToIssueish: this.props.switchToIssueish
          }, Component === _commitsView2.default && propsForCommits));
        } else {
          // eslint-disable-next-line no-console
          console.warn(`unrecognized timeline event type: ${type}`);
          return null;
        }
      }),
      this.renderLoadMore()
    );
  }

  renderLoadMore() {
    if (!this.props.relay.hasMore()) {
      return null;
    }

    return _react2.default.createElement(
      'div',
      { className: 'github-PrTimeline-loadMore' },
      _react2.default.createElement(
        'button',
        { className: 'github-PrTimeline-loadMoreButton btn', onClick: this.loadMore },
        this.props.relay.isLoading() ? _react2.default.createElement(_octicon2.default, { icon: 'ellipsis' }) : 'Load More'
      )
    );
  }

  groupEdges(edges) {
    let currentGroup;
    const groupedEdges = [];
    let lastEdgeType;
    edges.forEach(({ node, cursor }) => {
      const currentEdgeType = node.__typename;
      if (currentEdgeType === lastEdgeType) {
        currentGroup.edges.push({ node, cursor });
      } else {
        currentGroup = {
          type: currentEdgeType,
          edges: [{ node, cursor }]
        };
        groupedEdges.push(currentGroup);
      }
      lastEdgeType = currentEdgeType;
    });
    return groupedEdges;
  }
}
exports.default = IssueishTimelineView;
IssueishTimelineView.propTypes = {
  switchToIssueish: _propTypes2.default.func.isRequired,
  relay: _propTypes2.default.shape({
    hasMore: _propTypes2.default.func.isRequired,
    loadMore: _propTypes2.default.func.isRequired,
    isLoading: _propTypes2.default.func.isRequired
  }).isRequired,
  issue: _propTypes2.default.shape({
    timeline: TimelineConnectionPropType
  }),
  pullRequest: _propTypes2.default.shape({
    timeline: TimelineConnectionPropType
  }),
  onBranch: _propTypes2.default.bool,
  openCommit: _propTypes2.default.func
};
IssueishTimelineView.defaultProps = {
  onBranch: false,
  openCommit: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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