'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _commitDetailItem = require('../items/commit-detail-item');

var _commitDetailItem2 = _interopRequireDefault(_commitDetailItem);

var _issueishDetailItem = require('../items/issueish-detail-item');

var _issueishDetailItem2 = _interopRequireDefault(_issueishDetailItem);

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class FilePatchMetaView extends _react2.default.Component {

  renderMetaControls() {
    if (this.props.itemType === _commitDetailItem2.default || this.props.itemType === _issueishDetailItem2.default) {
      return null;
    }
    return _react2.default.createElement(
      'div',
      { className: 'github-FilePatchView-metaControls' },
      _react2.default.createElement(
        'button',
        {
          className: (0, _classnames2.default)('github-FilePatchView-metaButton', 'icon', this.props.actionIcon),
          onClick: this.props.action },
        this.props.actionText
      )
    );
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-FilePatchView-meta' },
      _react2.default.createElement(
        'div',
        { className: 'github-FilePatchView-metaContainer' },
        _react2.default.createElement(
          'header',
          { className: 'github-FilePatchView-metaHeader' },
          _react2.default.createElement(
            'h3',
            { className: 'github-FilePatchView-metaTitle' },
            this.props.title
          ),
          this.renderMetaControls()
        ),
        _react2.default.createElement(
          'div',
          { className: 'github-FilePatchView-metaDetails' },
          this.props.children
        )
      )
    );
  }
}
exports.default = FilePatchMetaView;
FilePatchMetaView.propTypes = {
  title: _propTypes2.default.string.isRequired,
  actionIcon: _propTypes2.default.string.isRequired,
  actionText: _propTypes2.default.string.isRequired,

  action: _propTypes2.default.func.isRequired,

  children: _propTypes2.default.element.isRequired,
  itemType: _propTypes3.ItemTypePropType.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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