'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class ErrorView extends _react2.default.Component {

  constructor(props) {
    super(props);

    (0, _helpers.autobind)(this, 'renderDescription');
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Message' },
      _react2.default.createElement(
        'div',
        { className: 'github-Message-wrapper' },
        _react2.default.createElement(
          'h1',
          { className: 'github-Message-title' },
          this.props.title
        ),
        this.props.descriptions.map(this.renderDescription),
        _react2.default.createElement(
          'div',
          { className: 'github-Message-action' },
          this.props.retry && _react2.default.createElement(
            'button',
            { className: 'github-Message-button btn btn-primary', onClick: this.props.retry },
            'Try Again'
          ),
          this.props.logout && _react2.default.createElement(
            'button',
            { className: 'github-Message-button btn btn-logout', onClick: this.props.logout },
            'Logout'
          )
        )
      )
    );
  }

  renderDescription(description, key) {
    if (this.props.preformatted) {
      return _react2.default.createElement(
        'pre',
        { key: key, className: 'github-Message-description' },
        description
      );
    } else {
      return _react2.default.createElement(
        'p',
        { key: key, className: 'github-Message-description' },
        description
      );
    }
  }
}
exports.default = ErrorView;
ErrorView.propTypes = {
  title: _propTypes2.default.string,
  descriptions: _propTypes2.default.arrayOf(_propTypes2.default.string),
  preformatted: _propTypes2.default.bool,

  retry: _propTypes2.default.func,
  logout: _propTypes2.default.func
};
ErrorView.defaultProps = {
  title: 'Error',
  descriptions: ['An unknown error occurred'],
  preformatted: false
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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