'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _eventKit = require('event-kit');

var _helpers = require('../helpers');

class StyleCalculator {
  constructor(styles, config) {
    (0, _helpers.autobind)(this, 'updateStyles');

    this.styles = styles;
    this.config = config;
  }

  startWatching(sourcePath, configsToWatch, getStylesheetFn) {
    const subscriptions = new _eventKit.CompositeDisposable();
    const updateStyles = () => {
      this.updateStyles(sourcePath, getStylesheetFn);
    };
    configsToWatch.forEach(configToWatch => {
      subscriptions.add(this.config.onDidChange(configToWatch, updateStyles));
    });
    updateStyles();
    return subscriptions;
  }

  updateStyles(sourcePath, getStylesheetFn) {
    const stylesheet = getStylesheetFn(this.config);
    this.styles.addStyleSheet(stylesheet, { sourcePath, priority: 0 });
  }
}
exports.default = StyleCalculator;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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